/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.feature.tree.helper;

import com.ametrinstudios.ametrin.world.gen.feature.tree.helper.TreeHelper;
import com.ametrinstudios.ametrin.world.gen.feature.tree.helper.TreePlaceContext;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public final class TreeHelper1x1 {
    public static final double CIRCULAR_LEAVES_ROUNDING_MULTIPLIER = 1.7;

    public static BlockPos placeTrunk(BlockState log, int height, TreePlaceContext context) {
        for (int y = 0; y < height; ++y) {
            TreeHelper.setBlockChecked(log, context.pos().above(y), context.level(), context.changedLogs());
        }
        return context.pos().above(height);
    }

    public static void squareLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    public static void squareSparseLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (context.random().nextBoolean()) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    public static void squareSparseLeaves(BlockState leaf, int radius, double decayChance, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (context.random().nextDouble() <= decayChance) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    public static void circularLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if ((double)(Math.abs(z) + Math.abs(x)) > (double)radius * 1.7) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    public static void circularSparseLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (context.random().nextBoolean() || (double)(Math.abs(z) + Math.abs(x)) > (double)radius * 1.7) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    public static void circularSparseLeaves(BlockState leaf, int radius, double decayChance, TreePlaceContext context) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (context.random().nextDouble() <= decayChance || (double)(Math.abs(z) + Math.abs(x)) > (double)radius * 1.7) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }
}

