/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.feature.tree.helper;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class TreeHelper {
    public static boolean setBlockChecked(BlockState blockState, BlockPos pos, WorldGenLevel level, @Nullable BiConsumer<BlockPos, BlockState> changedBlocks) {
        BlockState belowState;
        Block block = blockState.getBlock();
        if (blockState.is(BlockTags.LOGS)) {
            if (!TreeHelper.isReplaceableByLogs(pos, level)) {
                return false;
            }
            TreeHelper.setBlock(blockState, pos, level, changedBlocks);
            return true;
        }
        if (blockState.is(BlockTags.LEAVES)) {
            if (!TreeHelper.isReplaceableByLeaves(pos, level)) {
                return false;
            }
            TreeHelper.setBlock(blockState, pos, level, changedBlocks);
            return true;
        }
        if (!level.isEmptyBlock(pos) || !blockState.canSurvive((LevelReader)level, pos)) {
            return false;
        }
        TreeHelper.setBlock(blockState, pos, level, changedBlocks);
        if (block instanceof SnowLayerBlock && (belowState = level.getBlockState(pos.below())).hasProperty((Property)BlockStateProperties.SNOWY)) {
            level.setBlock(pos.below(), (BlockState)belowState.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }

    private static void setBlock(BlockState state, BlockPos pos, WorldGenLevel level, @Nullable BiConsumer<BlockPos, BlockState> changedBlocks) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && level.getFluidState(pos).is((Fluid)Fluids.WATER)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        if (changedBlocks == null) {
            TreeFeature.setBlockKnownShape((LevelWriter)level, (BlockPos)pos, (BlockState)state);
            return;
        }
        changedBlocks.accept(pos, state);
    }

    public static boolean isAreaBlocked(WorldGenLevel level, BlockPos pos, int trunkHeight, int trunkWidth, int leafStartHeight, int leafWidth) {
        if (pos.getY() >= 1 && pos.getY() + trunkHeight + 1 < level.getHeight()) {
            int x;
            int y;
            int width;
            if (trunkWidth == 1) {
                for (width = 0; width <= 1 + trunkHeight && pos.getY() + width >= 1 && pos.getY() + width < level.getHeight(); ++width) {
                    if (TreeHelper.isReplaceableByLogs(pos.above(width), level) || TreeHelper.isLeavesOrLog(level.getBlockState(pos.above(width)))) continue;
                    return true;
                }
            } else {
                for (width = 0; width <= 1 + trunkHeight && pos.getY() + width >= 1 && pos.getY() + width < level.getHeight(); ++width) {
                    for (y = 0; y < trunkWidth; ++y) {
                        for (x = 0; x < trunkWidth; ++x) {
                            if (TreeHelper.isReplaceableByLogs(pos.offset(y, width, x), level) || TreeHelper.isLeavesOrLog(level.getBlockState(pos.offset(y, width, x)))) continue;
                            return true;
                        }
                    }
                }
            }
            width = Math.max((leafWidth - 1) / 2, 1);
            for (y = leafStartHeight; y <= trunkHeight + 2 && pos.getY() + y >= 0 && pos.getY() + y < level.getHeight(); ++y) {
                for (x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (TreeHelper.isReplaceableByLeaves(pos.offset(x, y, z), level) || TreeHelper.isLeavesOrLog(level.getBlockState(pos.offset(x, y, z)))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isValidGround(BlockState state) {
        return Feature.isDirt((BlockState)state);
    }

    public static boolean isReplaceableByLeaves(BlockPos pos, WorldGenLevel level) {
        return TreeHelper.isReplaceableByLeaves(level.getBlockState(pos));
    }

    public static boolean isReplaceableByLogs(BlockPos pos, WorldGenLevel level) {
        return TreeHelper.isReplaceableByLogs(level.getBlockState(pos));
    }

    public static boolean isReplaceableByLeaves(BlockState state) {
        return state.canBeReplaced() || state.is(BlockTags.LEAVES);
    }

    public static boolean isReplaceableByLogs(BlockState state) {
        return state.canBeReplaced() || TreeHelper.isLeavesOrLog(state);
    }

    public static boolean isLeavesOrLog(BlockState state) {
        return state.is(BlockTags.LOGS) || state.is(BlockTags.LEAVES);
    }
}

