/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.entity.helper;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;

public final class BoatTypeHelper {
    public static EnumProxy<Boat.Type> createProxy(ResourceLocation name, Supplier<Block> planks, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem) {
        return BoatTypeHelper.createProxy(name, planks, boatItem, chestBoatItem, () -> Items.STICK, false);
    }

    public static EnumProxy<Boat.Type> createRaftProxy(ResourceLocation name, Supplier<Block> planks, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem) {
        return BoatTypeHelper.createProxy(name, planks, boatItem, chestBoatItem, () -> Items.STICK, true);
    }

    public static EnumProxy<Boat.Type> createProxy(ResourceLocation name, Supplier<Block> planks, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem, boolean isRaft) {
        return BoatTypeHelper.createProxy(name, planks, boatItem, chestBoatItem, () -> Items.STICK, isRaft);
    }

    public static EnumProxy<Boat.Type> createProxy(ResourceLocation name, Supplier<Block> planks, Supplier<BoatItem> boatItem, Supplier<BoatItem> chestBoatItem, Supplier<Item> stickItem, boolean isRaft) {
        return new EnumProxy(Boat.Type.class, new Object[]{planks, name.toString(), boatItem, chestBoatItem, stickItem, isRaft});
    }

    public static String getExtensionJson(Boat.Type boatType, Class<?> proxyClass) {
        return BoatTypeHelper.getExtensionJson(ResourceLocation.parse((String)boatType.name()), proxyClass);
    }

    public static String getExtensionJson(ResourceLocation id, Class<?> proxyClass) {
        String modID = id.getNamespace().toUpperCase();
        String boatTypeName = id.getPath().toUpperCase();
        String typeDescriptor = proxyClass.getName().replace('.', '/');
        return String.format("\n{\n  \"enum\": \"net/minecraft/world/entity/vehicle/Boat$Type\",\n  \"name\": %s_%s\",\n  \"constructor\": \"(Ljava/util/function/Supplier;Ljava/lang/String;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Z)V\",\n  \"parameters\": {\n    \"class\": \"%s\",\n    \"field\": \"%s\"\n  }\n}\n", modID, boatTypeName, typeDescriptor, boatTypeName);
    }
}

