/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.dimension.portal;

import com.ametrinstudios.ametrin.world.block.PortalBlock;
import com.ametrinstudios.ametrin.world.dimension.portal.PortalData;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class PortalHelper {
    private final PortalData data;

    public PortalHelper(PortalData data) {
        this.data = data;
    }

    @Nullable
    public DimensionTransition getExitPortal(ServerLevel level, Entity entity, BlockPos entryPos, BlockPos exitPos, boolean isTarget, WorldBorder worldBorder) {
        DimensionTransition.PostDimensionTransition postTransition;
        BlockUtil.FoundRectangle portalRect;
        Optional<BlockPos> closestPortalPosition = this.findClosestPortalPosition(level, exitPos, isTarget, worldBorder);
        if (closestPortalPosition.isPresent()) {
            BlockPos portalPos = closestPortalPosition.get();
            BlockState blockstate = level.getBlockState(portalPos);
            portalRect = BlockUtil.getLargestRectangleAround((BlockPos)portalPos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> level.getBlockState(pos) == blockstate);
            postTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(traveller -> traveller.placePortalTicket(portalPos));
        } else {
            Direction.Axis portalAxis = entity.level().getBlockState(entryPos).getOptionalValue(PortalBlock.AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> portal = this.createPortal(level, exitPos, portalAxis);
            if (portal.isEmpty()) {
                return null;
            }
            portalRect = portal.get();
            postTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return PortalHelper.getDimensionTransitionFromExit(entity, entryPos, portalRect, level, postTransition);
    }

    private Optional<BlockPos> findClosestPortalPosition(ServerLevel level, BlockPos exitPos, boolean isNether, WorldBorder worldBorder) {
        PoiManager poimanager = level.getPoiManager();
        int i = isNether ? 16 : 128;
        poimanager.ensureLoadedAndValid((LevelReader)level, exitPos, i);
        return poimanager.getInSquare(poiType -> poiType.is(this.data.portalPoi()), exitPos, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)worldBorder).isWithinBounds(arg_0)).filter(pos -> level.getBlockState(pos).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(p_352046_ -> p_352046_.distSqr((Vec3i)exitPos)).thenComparingInt(Vec3i::getY));
    }

    public static DimensionTransition getDimensionTransitionFromExit(Entity entity, BlockPos entryPos, BlockUtil.FoundRectangle portalRect, ServerLevel level, DimensionTransition.PostDimensionTransition postTransition) {
        Vec3 relativePosition;
        Direction.Axis portalAxis;
        BlockState blockState = entity.level().getBlockState(entryPos);
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            portalAxis = (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)entryPos, (Direction.Axis)portalAxis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.level().getBlockState(pos) == blockState);
            relativePosition = entity.getRelativePortalPosition(portalAxis, blockutil$foundrectangle);
        } else {
            portalAxis = Direction.Axis.X;
            relativePosition = new Vec3(0.5, 0.0, 0.0);
        }
        return PortalHelper.createDimensionTransition(level, portalRect, portalAxis, relativePosition, entity, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), postTransition);
    }

    public static DimensionTransition createDimensionTransition(ServerLevel level, BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 relativeOffset, Entity entity, Vec3 entitySpeed, float entityYRot, float entityXRot, DimensionTransition.PostDimensionTransition postTransition) {
        BlockPos cornerPos = portalRect.minCorner;
        BlockState frameBlockState = level.getBlockState(cornerPos);
        Direction.Axis frameDirection = frameBlockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        EntityDimensions entitydimensions = entity.getDimensions(entity.getPose());
        float rotationIncrease = portalAxis == frameDirection ? 0.0f : 90.0f;
        Vec3 newEntitySpeed = portalAxis == frameDirection ? entitySpeed : new Vec3(entitySpeed.z, entitySpeed.y, -entitySpeed.x);
        double d2 = (double)entitydimensions.width() / 2.0 + ((double)portalRect.axis1Size - (double)entitydimensions.width()) * relativeOffset.x();
        double d3 = ((double)portalRect.axis2Size - (double)entitydimensions.height()) * relativeOffset.y();
        double d4 = 0.5 + relativeOffset.z();
        boolean isXAxis = frameDirection == Direction.Axis.X;
        Vec3 rawPos = new Vec3((double)cornerPos.getX() + (isXAxis ? d2 : d4), (double)cornerPos.getY() + d3, (double)cornerPos.getZ() + (isXAxis ? d4 : d2));
        Vec3 newEntityPos = PortalShape.findCollisionFreePosition((Vec3)rawPos, (ServerLevel)level, (Entity)entity, (EntityDimensions)entitydimensions);
        return new DimensionTransition(level, newEntityPos, newEntitySpeed, entityYRot + rotationIncrease, entityXRot, postTransition);
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = level.getWorldBorder();
        int i = Math.min(level.getMaxBuildHeight(), level.getMinBuildHeight() + level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (BlockPos.MutableBlockPos spiralPos : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int k = Math.min(i, level.getHeight(Heightmap.Types.MOTION_BLOCKING, spiralPos.getX(), spiralPos.getZ()));
            if (!worldborder.isWithinBounds((BlockPos)spiralPos) || !worldborder.isWithinBounds((BlockPos)spiralPos.move(direction, 1))) continue;
            spiralPos.move(direction.getOpposite(), 1);
            for (int l = k; l >= level.getMinBuildHeight(); --l) {
                int j1;
                spiralPos.setY(l);
                if (!PortalHelper.canPortalReplaceBlock((Level)level, spiralPos)) continue;
                int i1 = l;
                while (l > level.getMinBuildHeight() && PortalHelper.canPortalReplaceBlock((Level)level, spiralPos.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                spiralPos.setY(l);
                if (!PortalHelper.canHostFrame((Level)level, (BlockPos)spiralPos, mutablePos, direction, 0)) continue;
                double d2 = pos.distSqr((Vec3i)spiralPos);
                if (PortalHelper.canHostFrame((Level)level, (BlockPos)spiralPos, mutablePos, direction, -1) && PortalHelper.canHostFrame((Level)level, (BlockPos)spiralPos, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = spiralPos.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = spiralPos.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        BlockState frameState = this.data.frameBlock().get();
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(level.getMinBuildHeight() - -1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(pos.getX() - direction.getStepX(), Mth.clamp((int)pos.getY(), (int)k1, (int)i2), pos.getZ() - direction.getStepZ()).immutable();
            blockpos = worldborder.clampToBounds(blockpos);
            Direction direction1 = direction.getClockWise();
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockState = k3 < 0 ? frameState : Blocks.AIR.defaultBlockState();
                        mutablePos.setWithOffset((Vec3i)blockpos, j3 * direction.getStepX() + i3 * direction1.getStepX(), k3, j3 * direction.getStepZ() + i3 * direction1.getStepZ());
                        level.setBlockAndUpdate((BlockPos)mutablePos, blockState);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                mutablePos.setWithOffset(blockpos, l1 * direction.getStepX(), j2, l1 * direction.getStepZ());
                level.setBlock((BlockPos)mutablePos, frameState, 3);
            }
        }
        BlockState portalState = (BlockState)this.data.portalBlock().get().setValue(PortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.setWithOffset((Vec3i)blockpos, k2 * direction.getStepX(), l2, k2 * direction.getStepZ());
                level.setBlock((BlockPos)mutablePos, portalState, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private static boolean canPortalReplaceBlock(Level level, BlockPos.MutableBlockPos pos) {
        BlockState blockstate = level.getBlockState((BlockPos)pos);
        return blockstate.canBeReplaced() && blockstate.getFluidState().isEmpty();
    }

    private static boolean canHostFrame(Level level, BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction direction, int offsetScale) {
        Direction actualDirection = direction.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.setWithOffset((Vec3i)originalPos, actualDirection.getStepX() * i + actualDirection.getStepX() * offsetScale, j, actualDirection.getStepZ() * i + actualDirection.getStepZ() * offsetScale);
                if (j < 0 && !level.getBlockState((BlockPos)offsetPos).isSolid()) {
                    return false;
                }
                if (j < 0 || PortalHelper.canPortalReplaceBlock(level, offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

