/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block.helper;

import com.ametrinstudios.ametrin.world.block.AgeableBushBlock;
import com.ametrinstudios.ametrin.world.block.helper.BlockBehaviourPropertiesHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class BlockRegisterHelper {
    private static final Supplier<FlowerPotBlock> EMPTY_POT_SUPPLIER = () -> (FlowerPotBlock)Blocks.FLOWER_POT;

    private BlockRegisterHelper() {
    }

    public static StairBlock stair(Supplier<Block> parent) {
        return BlockRegisterHelper.stair(parent.get());
    }

    public static StairBlock stair(Block parent) {
        return BlockRegisterHelper.stair(parent, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)parent));
    }

    public static StairBlock stair(Block base, BlockBehaviour.Properties properties) {
        return BlockRegisterHelper.stair(base.defaultBlockState(), properties);
    }

    public static StairBlock stair(Supplier<BlockState> base, BlockBehaviour.Properties properties) {
        return BlockRegisterHelper.stair(base.get(), properties);
    }

    public static StairBlock stair(BlockState base, BlockBehaviour.Properties properties) {
        return new StairBlock(base, properties);
    }

    public static FlowerPotBlock potted(Supplier<Block> main) {
        return new FlowerPotBlock(EMPTY_POT_SUPPLIER, main, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.POTTED_OAK_SAPLING));
    }

    public static AgeableBushBlock bush(int bonusDrop, int growRarity) {
        return new AgeableBushBlock(bonusDrop, growRarity, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.SWEET_BERRY_BUSH));
    }

    public static SaplingBlock sapling(TreeGrower treeGrower) {
        return new SaplingBlock(treeGrower, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.OAK_SAPLING));
    }

    public static ButtonBlock woodenButton() {
        return BlockRegisterHelper.woodenButton(BlockSetType.OAK);
    }

    public static ButtonBlock woodenButton(BlockSetType type) {
        return BlockRegisterHelper.button(type, 30, true);
    }

    public static ButtonBlock stoneButton() {
        return BlockRegisterHelper.stoneButton(BlockSetType.STONE);
    }

    public static ButtonBlock stoneButton(BlockSetType type) {
        return BlockRegisterHelper.button(type, 20, false);
    }

    public static ButtonBlock button(BlockSetType type, int ticksStayPressed, boolean arrowsCanPress) {
        return new ButtonBlock(type, ticksStayPressed, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
    }

    public static FenceGateBlock fenceGate(WoodType type, BlockBehaviour.Properties properties) {
        return new FenceGateBlock(type, properties);
    }

    public static FenceGateBlock fenceGate(BlockBehaviour.Properties properties, SoundEvent openSound, SoundEvent closeSound) {
        return new FenceGateBlock(properties, openSound, closeSound);
    }

    public static DoorBlock door(BlockBehaviour.Properties properties, BlockSetType type) {
        return new DoorBlock(type, properties);
    }

    public static TrapDoorBlock trapDoor(BlockBehaviour.Properties properties, BlockSetType type) {
        return new TrapDoorBlock(type, properties);
    }

    public static PressurePlateBlock woodenPressurePlate(MapColor mapColor, BlockSetType type) {
        return BlockRegisterHelper.pressurePlate(BlockRegisterHelper.basePressurePlateProperties(mapColor, NoteBlockInstrument.BASS).ignitedByLava(), type);
    }

    public static PressurePlateBlock stonePressurePlate(MapColor mapColor, BlockSetType type) {
        return BlockRegisterHelper.pressurePlate(BlockRegisterHelper.basePressurePlateProperties(mapColor, NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops(), type);
    }

    public static PressurePlateBlock pressurePlate(BlockBehaviour.Properties properties, BlockSetType type) {
        return new PressurePlateBlock(type, properties);
    }

    public static BlockBehaviour.Properties basePressurePlateProperties(DyeColor mapColor, NoteBlockInstrument instrument) {
        return BlockRegisterHelper.internalPressurePlateProperties(instrument).mapColor(mapColor);
    }

    public static BlockBehaviour.Properties basePressurePlateProperties(MapColor mapColor, NoteBlockInstrument instrument) {
        return BlockRegisterHelper.internalPressurePlateProperties(instrument).mapColor(mapColor);
    }

    public static BlockBehaviour.Properties basePressurePlateProperties(Function<BlockState, MapColor> mapColor, NoteBlockInstrument instrument) {
        return BlockRegisterHelper.internalPressurePlateProperties(instrument).mapColor(mapColor);
    }

    private static BlockBehaviour.Properties internalPressurePlateProperties(NoteBlockInstrument instrument) {
        return BlockBehaviour.Properties.of().forceSolidOn().instrument(instrument).noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }

    public static ToIntFunction<BlockState> litEmission(int lightLevel) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightLevel : 0;
    }

    public static ToIntFunction<BlockState> litEmission(ToIntFunction<BlockState> lightLevel) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightLevel.applyAsInt((BlockState)state) : 0;
    }

    public static ToIntFunction<BlockState> emission(int lightLevel) {
        return state -> lightLevel;
    }
}

