/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block;

import com.ametrinstudios.ametrin.world.dimension.portal.PortalData;
import com.ametrinstudios.ametrin.world.dimension.portal.PortalHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected final PortalData data;
    protected final PortalHelper helper;

    public PortalBlock(PortalData data, int lightLevel) {
        this(data, SoundType.GLASS, lightLevel);
    }

    public PortalBlock(PortalData data, SoundType soundType, int lightLevel) {
        this(data, BlockBehaviour.Properties.of().strength(-1.0f).noCollission().lightLevel(state -> lightLevel).noLootTable().randomTicks().sound(soundType));
    }

    public PortalBlock(PortalData data, BlockBehaviour.Properties properties) {
        super(properties);
        this.data = data;
        this.helper = data.createHelper();
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected BlockState updateShape(BlockState thisState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos thisPos, BlockPos facingPos) {
        Direction.Axis facingAxis = facing.getAxis();
        Direction.Axis thisAxis = (Direction.Axis)thisState.getValue(AXIS);
        boolean flag = thisAxis != facingAxis && facingAxis.isHorizontal();
        return !flag && !facingState.is((Block)this) && !new PortalShape(level, thisPos, thisAxis).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(thisState, facing, facingState, level, thisPos, facingPos);
    }

    @ParametersAreNonnullByDefault
    protected void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(true)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @ParametersAreNonnullByDefault
    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = Math.max(1, level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        ResourceKey<Level> destinationLevelKey = level.dimension() == this.data.dimensionA() ? this.data.dimensionB() : this.data.dimensionA();
        ServerLevel destinationLevel = level.getServer().getLevel(destinationLevelKey);
        if (destinationLevel == null) {
            return null;
        }
        boolean isDestinationLevelB = destinationLevel.dimension() == this.data.dimensionB();
        WorldBorder worldBorder = destinationLevel.getWorldBorder();
        double coordinateScale = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)destinationLevel.dimensionType());
        BlockPos scaledPosition = worldBorder.clampToBounds(entity.getX() * coordinateScale, entity.getY(), entity.getZ() * coordinateScale);
        return this.helper.getExitPortal(destinationLevel, entity, pos, scaledPosition, isDestinationLevelB, worldBorder);
    }

    @ParametersAreNonnullByDefault
    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            this.data.soundEvent().ifPresent(soundEvent -> level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false));
        }
        this.data.particles().ifPresent(particles -> {
            for (int i = 0; i < 4; ++i) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble();
                double z = (double)pos.getZ() + random.nextDouble();
                double xSpeed = ((double)random.nextFloat() - 0.5) * 0.5;
                double ySpeed = ((double)random.nextFloat() - 0.5) * 0.5;
                double zSpeed = ((double)random.nextFloat() - 0.5) * 0.5;
                int j = random.nextInt(2) * 2 - 1;
                if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                    x = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                    xSpeed = random.nextFloat() * 2.0f * (float)j;
                } else {
                    z = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                    zSpeed = random.nextFloat() * 2.0f * (float)j;
                }
                level.addParticle(particles, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        });
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState blockState, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)blockState.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)blockState.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)blockState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield blockState;
            }
            default -> blockState;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return blockState.getValue(AXIS) == Direction.Axis.Z ? Z_AXIS_AABB : X_AXIS_AABB;
    }

    @NotNull
    public Portal.Transition getLocalTransition() {
        return this.data.transition();
    }
}

