/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface IAgeablePlant
extends BonemealableBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public void onHarvest(BlockState var1, Level var2, BlockPos var3, Player var4);

    @ParametersAreNonnullByDefault
    default public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState blockState) {
        return this.isSparse(blockState);
    }

    @ParametersAreNonnullByDefault
    default public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState blockState) {
        return true;
    }

    default public boolean isSparse(BlockState blockState) {
        return this.isSparse((Integer)blockState.getValue((Property)AGE));
    }

    default public boolean isSparse(int age) {
        return age < 3;
    }

    default public boolean isFullyAged(BlockState blockState) {
        return this.isFullyAged((Integer)blockState.getValue((Property)AGE));
    }

    default public boolean isFullyAged(int age) {
        return age >= 3;
    }
}

