/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CustomWallTorchBlock
extends WallTorchBlock {
    protected final Supplier<SimpleParticleType> particle;

    public CustomWallTorchBlock(BlockBehaviour.Properties properties, Supplier<SimpleParticleType> particle) {
        super(ParticleTypes.FLAME, properties);
        this.particle = particle;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, @NotNull RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction direction = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + 0.27 * (double)direction.getStepX(), y + 0.22, z + 0.27 * (double)direction.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.particle.get(), x + 0.27 * (double)direction.getStepX(), y + 0.22, z + 0.27 * (double)direction.getStepZ(), 0.0, 0.0, 0.0);
    }
}

