/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block;

import com.ametrinstudios.ametrin.world.block.IAgeablePlant;
import com.ametrinstudios.ametrin.world.block.SimpleDoublePlantBlock;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class AgeableDoublePlantBlock
extends SimpleDoublePlantBlock
implements BonemealableBlock,
IAgeablePlant {
    public final int GrowRarity;
    public final int BonusDrop;
    public final Supplier<Item> item;

    public AgeableDoublePlantBlock(int growRarity, int bonusDrop, Supplier<Item> item, BlockBehaviour.Properties properties) {
        super(properties);
        this.item = item;
        this.GrowRarity = growRarity;
        this.BonusDrop = bonusDrop;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public void onHarvest(BlockState blockState, Level level, BlockPos pos, Player player) {
        int dropAmount = 1;
        if (this.BonusDrop > 0) {
            dropAmount += level.random.nextInt(this.BonusDrop);
        }
        AgeableDoublePlantBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem(), dropAmount));
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        this.setAgeInLevel(1, blockState, level, pos, player);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (itemStack.is(Items.BONE_MEAL) && this.isSparse(blockState)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (itemStack.is(Items.BOWL) && this.isFullyAged(blockState)) {
            this.onHarvest(blockState, level, pos, player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(itemStack, blockState, level, pos, player, hand, hitResult);
    }

    @ParametersAreNonnullByDefault
    public void randomTick(BlockState currentState, ServerLevel level, BlockPos pos, RandomSource random) {
        if (currentState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        int currentAge = (Integer)currentState.getValue((Property)AGE);
        if (this.isSparse(currentAge) && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)currentState, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            this.setAgeInLevel(currentAge + 1, currentState, (Level)level, pos, true);
        }
    }

    protected void setAgeInLevel(int age, BlockState blockState, Level level, BlockPos pos, Player player) {
        this.setAgeSingle(age, blockState, level, pos, player);
        BlockPos otherPos = blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        this.setAgeSingle(age, level.getBlockState(otherPos), level, otherPos, player);
    }

    private void setAgeSingle(int age, BlockState blockState, Level level, BlockPos pos, Player player) {
        BlockState newState = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        level.setBlock(pos, newState, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
    }

    protected void setAgeInLevel(int age, BlockState blockState, Level level, BlockPos pos, boolean triggerEvents) {
        this.setAgeSingle(age, blockState, level, pos, triggerEvents, triggerEvents);
        BlockPos otherPos = blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        this.setAgeSingle(age, level.getBlockState(otherPos), level, otherPos, triggerEvents, triggerEvents);
    }

    private void setAgeSingle(int age, BlockState blockState, Level level, BlockPos pos, boolean fireChangeEvent, boolean fireGrowHook) {
        BlockState newState = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        level.setBlock(pos, newState, 2);
        if (fireGrowHook) {
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)newState);
        }
        if (fireChangeEvent) {
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    @ParametersAreNonnullByDefault
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        if (this.isFullyAged(blockState)) {
            return;
        }
        this.setAgeInLevel((Integer)blockState.getValue((Property)AGE) + 1, blockState, (Level)level, pos, false);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{AGE});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.item.get());
    }

    @ParametersAreNonnullByDefault
    public boolean isRandomlyTicking(BlockState blockState) {
        return this.isSparse(blockState);
    }
}

