/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.block;

import com.ametrinstudios.ametrin.world.block.IAgeablePlant;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class AgeableBushBlock
extends BushBlock
implements IAgeablePlant {
    public static final MapCodec<AgeableBushBlock> CODEC = AgeableBushBlock.simpleCodec(properties -> new AgeableBushBlock(0, 0, (BlockBehaviour.Properties)properties));
    public final int GrowRarity;
    public final int BonusDrop;
    private static final VoxelShape SaplingShape = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MidGrowthShape = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public AgeableBushBlock(int bonusDrop, int growRate, BlockBehaviour.Properties properties) {
        super(properties);
        this.GrowRarity = growRate;
        this.BonusDrop = bonusDrop;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.asItem());
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)blockState.getValue((Property)AGE) == 0) {
            return SaplingShape;
        }
        return (Integer)blockState.getValue((Property)AGE) < 3 ? MidGrowthShape : super.getShape(blockState, level, pos, context);
    }

    public boolean isRandomlyTicking(@NotNull BlockState blockState) {
        return this.isSparse(blockState);
    }

    @ParametersAreNonnullByDefault
    public void randomTick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)blockState.getValue((Property)AGE);
        if (i < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)blockState, (random.nextInt(this.GrowRarity) == 0 ? 1 : 0) != 0)) {
            BlockState newState = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, newState, 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)blockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    @Override
    public void onHarvest(BlockState blockState, Level level, BlockPos pos, Player player) {
        int dropAmount = 1;
        if (this.BonusDrop > 0) {
            dropAmount += level.random.nextInt(this.BonusDrop);
        }
        AgeableBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem(), dropAmount));
        level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        BlockState newState = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
        level.setBlock(pos, newState, 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.isSparse(blockState) && itemStack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(itemStack, blockState, level, pos, player, hand, hitResult);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.isSparse(blockState)) {
            return super.useWithoutItem(blockState, level, pos, player, hitResult);
        }
        this.onHarvest(blockState, level, pos, player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{AGE});
    }

    @ParametersAreNonnullByDefault
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        if (this.isFullyAged(blockState)) {
            return;
        }
        level.setBlock(pos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockState.getValue((Property)AGE) + 1))), 2);
    }

    @ParametersAreNonnullByDefault
    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    @ParametersAreNonnullByDefault
    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 100;
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }
}

