/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.ApiStatus;

public final class VanillaCompat {
    private static final Map<Block, Block> _strippableRequests = new HashMap<Block, Block>();
    private static boolean _pushed = false;

    public static void addFlowerPot(ResourceLocation plant, Supplier<? extends FlowerPotBlock> fullPot) {
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(plant, fullPot);
    }

    public static void addFlowerPot(DeferredBlock<? extends Block> plant, Supplier<? extends FlowerPotBlock> fullPot) {
        VanillaCompat.addFlowerPot(plant.getId(), fullPot);
    }

    public static void addStrippable(Block log, Block strippedLog) {
        if (_pushed) {
            throw new UnsupportedOperationException("Strippables must be registered during FMLCommonSetupEvent");
        }
        _strippableRequests.put(log, strippedLog);
    }

    @Deprecated(forRemoval=true)
    private static void addFlattenable(Block block, BlockState flattenedBlockState) {
    }

    @Deprecated(forRemoval=true)
    private static void addFlattenable(Block block, Block flattenedBlock) {
    }

    @ApiStatus.Internal
    public static void injectRequests() {
        _pushed = true;
        AxeItem.STRIPPABLES = new ImmutableMap.Builder().putAll(AxeItem.STRIPPABLES).putAll(_strippableRequests).build();
    }

    public static interface Flammable {
        public static void add(Block block, int encouragement, int flammability) {
            ((FireBlock)Blocks.FIRE).setFlammable(block, encouragement, flammability);
        }

        public static void addLog(Block log) {
            Flammable.add(log, 5, 5);
        }

        public static void addPlank(Block plank) {
            Flammable.add(plank, 5, 20);
        }

        public static void addLeave(Block leave) {
            Flammable.add(leave, 30, 60);
        }

        public static void addPlant(Block plant) {
            Flammable.add(plant, 60, 100);
        }

        public static void addWool(Block wool) {
            Flammable.add(wool, 30, 60);
        }

        public static void addCarpet(Block carpet) {
            Flammable.add(carpet, 60, 20);
        }
    }
}

