/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.mixin;

import com.ametrinstudios.ametrin.util.mixin.IMixinBlockBehaviorProperties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockBehaviour.Properties.class})
public abstract class MixinBlockBehaviorProperties
implements IMixinBlockBehaviorProperties {
    @Shadow
    Function<BlockState, MapColor> mapColor;
    @Shadow
    boolean hasCollision;
    @Shadow
    SoundType soundType;
    @Shadow
    ToIntFunction<BlockState> lightEmission;
    @Shadow
    float explosionResistance;
    @Shadow
    float destroyTime;
    @Shadow
    boolean requiresCorrectToolForDrops;
    @Shadow
    boolean isRandomlyTicking;
    @Shadow
    float friction;
    @Shadow
    float speedFactor;
    @Shadow
    float jumpFactor;
    @Shadow
    ResourceKey<LootTable> drops;
    @Shadow
    boolean canOcclude;
    @Shadow
    boolean isAir;
    @Shadow
    boolean ignitedByLava;
    @Shadow
    boolean liquid;
    @Shadow
    boolean forceSolidOn;
    @Shadow
    PushReaction pushReaction;
    @Shadow
    boolean spawnTerrainParticles;
    @Shadow
    NoteBlockInstrument instrument;
    @Shadow
    boolean replaceable;
    @Shadow
    private Supplier<ResourceLocation> lootTableSupplier;
    @Shadow
    BlockBehaviour.StateArgumentPredicate<EntityType<?>> isValidSpawn;
    @Shadow
    BlockBehaviour.StatePredicate isRedstoneConductor;
    @Shadow
    BlockBehaviour.StatePredicate isSuffocating;
    @Shadow
    BlockBehaviour.StatePredicate isViewBlocking;
    @Shadow
    BlockBehaviour.StatePredicate hasPostProcess;
    @Shadow
    BlockBehaviour.StatePredicate emissiveRendering;
    @Shadow
    boolean dynamicShape;
    @Shadow
    FeatureFlagSet requiredFeatures;
    @Shadow
    BlockBehaviour.OffsetFunction offsetFunction;

    @Override
    public BlockBehaviour.Properties copy() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(this.mapColor).sound(this.soundType).lightLevel(this.lightEmission).strength(this.destroyTime, this.explosionResistance).friction(this.friction).speedFactor(this.speedFactor).jumpFactor(this.jumpFactor).pushReaction(this.pushReaction).instrument(this.instrument).isValidSpawn(this.isValidSpawn).isRedstoneConductor(this.isRedstoneConductor).isSuffocating(this.isSuffocating).hasPostProcess(this.hasPostProcess).emissiveRendering(this.emissiveRendering);
        if (!this.hasCollision) {
            properties.noCollission();
        }
        if (this.requiresCorrectToolForDrops) {
            properties.requiresCorrectToolForDrops();
        }
        if (this.isRandomlyTicking) {
            properties.randomTicks();
        }
        if (!this.canOcclude) {
            properties.noOcclusion();
        }
        if (this.isAir) {
            properties.air();
        }
        if (this.ignitedByLava) {
            properties.ignitedByLava();
        }
        if (this.liquid) {
            properties.liquid();
        }
        if (this.forceSolidOn) {
            properties.forceSolidOn();
        }
        if (!this.spawnTerrainParticles) {
            properties.noTerrainParticles();
        }
        if (this.replaceable) {
            properties.replaceable();
        }
        if (this.isViewBlocking != this.isSuffocating) {
            properties.isViewBlocking(this.isViewBlocking);
        }
        if (this.dynamicShape) {
            properties.dynamicShape();
        }
        IMixinBlockBehaviorProperties mixinProperties = (IMixinBlockBehaviorProperties)properties;
        mixinProperties.SetFeatureFlagSet(this.requiredFeatures);
        mixinProperties.SetOffsetFunction(this.offsetFunction);
        if (this.lootTableSupplier != null) {
            mixinProperties.SetLootTableSupplier(this.lootTableSupplier);
        } else if (this.drops == BuiltInLootTables.EMPTY) {
            properties.noLootTable();
        }
        return properties;
    }

    @Override
    public void SetOffsetFunction(BlockBehaviour.OffsetFunction func) {
        this.offsetFunction = func;
    }

    @Override
    public void SetFeatureFlagSet(FeatureFlagSet featureFlags) {
        this.requiredFeatures = featureFlags;
    }

    @Override
    public void SetLootTableSupplier(Supplier<ResourceLocation> lootTable) {
        this.lootTableSupplier = lootTable;
    }
}

