/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider.loot_table;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public abstract class ExtendedBlockLootSubProvider
extends BlockLootSubProvider {
    protected ExtendedBlockLootSubProvider(HolderLookup.Provider registries) {
        this(Set.of(), registries);
    }

    protected ExtendedBlockLootSubProvider(Set<Item> explosionResistant, HolderLookup.Provider registries) {
        super(explosionResistant, FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void dropOther(DeferredBlock<? extends Block> block, ItemLike other) {
        this.dropOther((Block)block.get(), other);
    }

    protected void dropLeaveLoot(Block block, SaplingBlock sapling) {
        this.add(block, this.createLeavesDrops(block, (Block)sapling, NORMAL_LEAVES_SAPLING_CHANCES));
    }

    protected void dropDoor(Block door) {
        this.add(door, this.createDoorTable(door));
    }

    protected void dropOre(Block block, ItemLike drop) {
        this.add(block, this.createOreDrop(block, drop.asItem()));
    }

    protected void dropDoublePlant(Block plant) {
        this.add(plant, this.createSinglePropConditionTable(plant, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void dropDoublePlantOther(Block plant, ItemLike drop) {
        this.add(plant, this.createSinglePropConditionTableDropOther(plant, drop, (Property)DoublePlantBlock.HALF, (Comparable<T> & StringRepresentable)DoubleBlockHalf.LOWER));
    }

    protected void dropCampfire(Block campfireBlock, ItemLike charcoal) {
        this.add(campfireBlock, this.createSilkTouchDispatchTable(campfireBlock, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)campfireBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)charcoal).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
    }

    protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTableDropOther(Block block, ItemLike dropItem, Property<T> property, T validValue) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)dropItem).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, validValue))))));
    }

    protected final void dropSelf(Block ... blocks) {
        this.dropSelf(Arrays.stream(blocks).iterator());
    }

    @SafeVarargs
    protected final void dropSelf(DeferredBlock<? extends Block> ... blocks) {
        this.dropSelf(Arrays.stream(blocks).map(DeferredHolder::get).iterator());
    }

    protected void dropSelf(Iterator<? extends Block> blocks) {
        blocks.forEachRemaining(x$0 -> this.dropSelf((Block)x$0));
    }

    protected void dropSelf(DeferredBlock<? extends Block> block) {
        this.dropSelf((Block)block.get());
    }

    @NotNull
    protected abstract Iterable<Block> getKnownBlocks();
}

