/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ExtendedRecipeProvider
extends RecipeProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static Set<ResourceLocation> _recipes = Sets.newHashSet();
    protected static String currentModID;
    protected String modID;

    public ExtendedRecipeProvider(PackOutput packOutput, String modID, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
        this.modID = modID;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected CompletableFuture<?> run(final CachedOutput output, final HolderLookup.Provider registries) {
        currentModID = this.modID;
        final ArrayList list = new ArrayList();
        this.buildRecipes(new RecipeOutput(){

            @ParametersAreNonnullByDefault
            public void accept(ResourceLocation resourceLocation, Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... conditions) {
                if (!_recipes.add(resourceLocation)) {
                    throw new IllegalStateException("Duplicate recipe " + String.valueOf(resourceLocation));
                }
                list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Recipe.CONDITIONAL_CODEC, Optional.of(new WithConditions(recipe, conditions)), (Path)ExtendedRecipeProvider.this.recipePathProvider.json(resourceLocation)));
                if (advancementHolder != null) {
                    list.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, (Codec)Advancement.CONDITIONAL_CODEC, Optional.of(new WithConditions((Object)advancementHolder.value(), conditions)), (Path)ExtendedRecipeProvider.this.advancementPathProvider.json(advancementHolder.id())));
                }
            }

            @NotNull
            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildRecipes(@NotNull RecipeOutput var1);

    protected static void stairSlabWallButton(RecipeOutput output, @Nullable ItemLike stair, @Nullable ItemLike slab, @Nullable ItemLike wall, @Nullable ItemLike button, ItemLike material, boolean hasStonecutting) {
        if (stair != null) {
            ExtendedRecipeProvider.stairs(output, stair, material, hasStonecutting);
        }
        if (slab != null) {
            ExtendedRecipeProvider.slab(output, slab, material, hasStonecutting);
        }
        if (wall != null) {
            ExtendedRecipeProvider.wall(output, wall, material, hasStonecutting);
        }
        if (button != null) {
            ExtendedRecipeProvider.button(output, button, material, hasStonecutting);
        }
    }

    protected static void stairSlabWallButton(RecipeOutput output, @Nullable ItemLike stair, @Nullable ItemLike slab, @Nullable ItemLike wall, @Nullable ItemLike button, ItemLike material, ItemLike ... additionalStonecuttingMaterials) {
        if (stair != null) {
            ExtendedRecipeProvider.stairs(output, stair, material, additionalStonecuttingMaterials);
        }
        if (slab != null) {
            ExtendedRecipeProvider.slab(output, slab, material, additionalStonecuttingMaterials);
        }
        if (wall != null) {
            ExtendedRecipeProvider.wall(output, wall, material, additionalStonecuttingMaterials);
        }
        if (button != null) {
            ExtendedRecipeProvider.button(output, button, material, additionalStonecuttingMaterials);
        }
    }

    protected static void stairs(RecipeOutput output, ItemLike stair, ItemLike material, boolean hasStonecutting) {
        ExtendedRecipeProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(stair, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.BUILDING_BLOCKS, stair, 1, material);
        }
    }

    protected static void stairs(RecipeOutput output, ItemLike stair, ItemLike material, ItemLike ... additionalStonecuttingMaterials) {
        ExtendedRecipeProvider.stairs(output, stair, material, true);
        for (ItemLike mat : additionalStonecuttingMaterials) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.BUILDING_BLOCKS, stair, 1, mat);
        }
    }

    protected static void slab(RecipeOutput output, ItemLike slab, ItemLike material, boolean hasStonecutting) {
        ExtendedRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(slab, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.BUILDING_BLOCKS, slab, 2, material);
        }
    }

    protected static void slab(RecipeOutput output, ItemLike slab, ItemLike material, ItemLike ... additionalStonecuttingMaterials) {
        ExtendedRecipeProvider.slab(output, slab, material, true);
        for (ItemLike mat : additionalStonecuttingMaterials) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.BUILDING_BLOCKS, slab, ExtendedRecipeProvider.getItemName((ItemLike)mat).contains("slab") ? 1 : 2, mat);
        }
    }

    protected static void wall(RecipeOutput output, ItemLike wall, ItemLike material, boolean hasStonecutting) {
        ExtendedRecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(wall, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.DECORATIONS, wall, 1, material);
        }
    }

    protected static void wall(RecipeOutput output, ItemLike wall, ItemLike material, ItemLike ... additionalStonecuttingMaterials) {
        ExtendedRecipeProvider.wall(output, wall, material, true);
        for (ItemLike mat : additionalStonecuttingMaterials) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.DECORATIONS, wall, 1, mat);
        }
    }

    protected static void button(RecipeOutput output, ItemLike button, ItemLike material, boolean hasStonecutting) {
        ExtendedRecipeProvider.buttonBuilder((ItemLike)button, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(button, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.REDSTONE, button, 1, material);
        }
    }

    protected static void button(RecipeOutput output, ItemLike button, ItemLike material, ItemLike ... additionalStonecuttingMaterials) {
        ExtendedRecipeProvider.button(output, button, material, true);
        for (ItemLike item : additionalStonecuttingMaterials) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.REDSTONE, button, 1, item);
        }
    }

    protected static void chiseled(RecipeOutput output, ItemLike chiseled, ItemLike material, boolean hasStonecutting) {
        ExtendedRecipeProvider.chiseledBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseled, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(chiseled, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.BUILDING_BLOCKS, chiseled, 1, material);
        }
    }

    protected static void fence(RecipeOutput output, ItemLike fence, ItemLike material) {
        ExtendedRecipeProvider.fence(output, fence, 3, material, (ItemLike)Items.STICK, false);
    }

    protected static void netherFence(RecipeOutput output, ItemLike fence, ItemLike material) {
        ExtendedRecipeProvider.fence(output, fence, 6, material, (ItemLike)Items.NETHER_BRICK, true);
    }

    protected static void fence(RecipeOutput output, ItemLike fence, int count, ItemLike material, ItemLike stick, boolean hasStonecutting) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)count).define(Character.valueOf('W'), material).define(Character.valueOf('#'), stick).pattern("W#W").pattern("W#W").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(fence, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.DECORATIONS, fence, 1, material);
        }
    }

    protected static void fenceGate(RecipeOutput output, ItemLike fenceGate, ItemLike material) {
        ExtendedRecipeProvider.fenceGate(output, fenceGate, material, (ItemLike)Items.STICK, false);
    }

    protected static void netherFenceGate(RecipeOutput output, ItemLike fenceGate, ItemLike material) {
        ExtendedRecipeProvider.fenceGate(output, fenceGate, material, (ItemLike)Items.NETHER_BRICK, true);
    }

    protected static void fenceGate(RecipeOutput output, ItemLike fenceGate, ItemLike material, ItemLike stick, boolean hasStonecutting) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).define(Character.valueOf('#'), stick).define(Character.valueOf('W'), material).pattern("#W#").pattern("#W#").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(fenceGate, material));
        if (hasStonecutting) {
            ExtendedRecipeProvider.stonecutting(output, RecipeCategory.REDSTONE, fenceGate, 1, material);
        }
    }

    protected static void door(RecipeOutput output, ItemLike door, ItemLike material) {
        ExtendedRecipeProvider.doorBuilder((ItemLike)door, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(door, material));
    }

    protected static void trapdoor(RecipeOutput output, ItemLike trapdoor, ItemLike material) {
        ExtendedRecipeProvider.trapdoorBuilder((ItemLike)trapdoor, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(trapdoor, material));
    }

    protected static void torch(RecipeOutput output, ItemLike torch, ItemLike flammable) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torch).define(Character.valueOf('#'), flammable).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)flammable), ExtendedRecipeProvider.has((ItemLike)flammable)).save(output, ExtendedRecipeProvider.recipeID(torch, flammable));
    }

    protected static void torch(RecipeOutput output, ItemLike torch, TagKey<Item> flammable) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)torch).define(Character.valueOf('#'), flammable).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName(flammable), ExtendedRecipeProvider.has(flammable)).save(output, ExtendedRecipeProvider.recipeID(torch, flammable));
    }

    protected static void campfire(RecipeOutput output, ItemLike campfire, ItemLike flammable) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)campfire).define(Character.valueOf('|'), (ItemLike)Items.STICK).define(Character.valueOf('#'), flammable).define(Character.valueOf('O'), ItemTags.LOGS_THAT_BURN).pattern(" | ").pattern("|#|").pattern("OOO").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)flammable), ExtendedRecipeProvider.has((ItemLike)flammable)).save(output, ExtendedRecipeProvider.recipeID(campfire, flammable));
    }

    protected static void campfire(RecipeOutput output, ItemLike campfire, TagKey<Item> flammable) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)campfire).define(Character.valueOf('|'), (ItemLike)Items.STICK).define(Character.valueOf('#'), flammable).define(Character.valueOf('O'), ItemTags.LOGS_THAT_BURN).pattern(" | ").pattern("|#|").pattern("OOO").unlockedBy(ExtendedRecipeProvider.getHasName(flammable), ExtendedRecipeProvider.has(flammable)).save(output, ExtendedRecipeProvider.recipeID(campfire, flammable));
    }

    protected static void lantern(RecipeOutput output, ItemLike lantern, ItemLike nugget, ItemLike torch) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)lantern).define(Character.valueOf('|'), nugget).define(Character.valueOf('#'), torch).pattern("|||").pattern("|#|").pattern("|||").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)torch), ExtendedRecipeProvider.has((ItemLike)torch)).save(output, ExtendedRecipeProvider.recipeID(lantern, nugget));
    }

    protected static void lantern(RecipeOutput output, ItemLike lantern, TagKey<Item> nugget, ItemLike torch) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)lantern).define(Character.valueOf('|'), nugget).define(Character.valueOf('#'), torch).pattern("|||").pattern("|#|").pattern("|||").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)torch), ExtendedRecipeProvider.has((ItemLike)torch)).save(output, ExtendedRecipeProvider.recipeID(lantern, nugget));
    }

    protected static void tools(RecipeOutput output, ItemLike sword, ItemLike axe, ItemLike pickaxe, ItemLike shovel, ItemLike hoe, ItemLike material) {
        ExtendedRecipeProvider.sword(output, sword, material);
        ExtendedRecipeProvider.axe(output, axe, material);
        ExtendedRecipeProvider.pickaxe(output, pickaxe, material);
        ExtendedRecipeProvider.shovel(output, shovel, material);
        ExtendedRecipeProvider.hoe(output, hoe, material);
    }

    protected static void tools(RecipeOutput output, ItemLike sword, ItemLike axe, ItemLike pickaxe, ItemLike shovel, ItemLike hoe, TagKey<Item> material) {
        ExtendedRecipeProvider.sword(output, sword, material);
        ExtendedRecipeProvider.axe(output, axe, material);
        ExtendedRecipeProvider.pickaxe(output, pickaxe, material);
        ExtendedRecipeProvider.shovel(output, shovel, material);
        ExtendedRecipeProvider.hoe(output, hoe, material);
    }

    protected static void sword(RecipeOutput output, ItemLike sword, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sword).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("#").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(sword, material));
    }

    protected static void sword(RecipeOutput output, ItemLike sword, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sword).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("#").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(sword, material));
    }

    protected static void axe(RecipeOutput output, ItemLike axe, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("##").pattern("#|").pattern(" |").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(axe, material));
    }

    protected static void axe(RecipeOutput output, ItemLike axe, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("##").pattern("#|").pattern(" |").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(axe, material));
    }

    protected static void pickaxe(RecipeOutput output, ItemLike pickaxe, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("###").pattern(" | ").pattern(" | ").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(pickaxe, material));
    }

    protected static void pickaxe(RecipeOutput output, ItemLike pickaxe, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("###").pattern(" | ").pattern(" | ").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(pickaxe, material));
    }

    protected static void shovel(RecipeOutput output, ItemLike shovel, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("|").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(shovel, material));
    }

    protected static void shovel(RecipeOutput output, ItemLike shovel, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("#").pattern("|").pattern("|").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(shovel, material));
    }

    protected static void hoe(RecipeOutput output, ItemLike hoe, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("##").pattern("| ").pattern("| ").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(hoe, material));
    }

    protected static void hoe(RecipeOutput output, ItemLike hoe, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("##").pattern("| ").pattern("| ").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(hoe, material));
    }

    protected static void armor(RecipeOutput output, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots, ItemLike material) {
        ExtendedRecipeProvider.helmet(output, helmet, material);
        ExtendedRecipeProvider.chestplate(output, chestplate, material);
        ExtendedRecipeProvider.leggings(output, leggings, material);
        ExtendedRecipeProvider.boots(output, boots, material);
    }

    protected static void armor(RecipeOutput output, ItemLike helmet, ItemLike chestplate, ItemLike leggings, ItemLike boots, TagKey<Item> material) {
        ExtendedRecipeProvider.helmet(output, helmet, material);
        ExtendedRecipeProvider.chestplate(output, chestplate, material);
        ExtendedRecipeProvider.leggings(output, leggings, material);
        ExtendedRecipeProvider.boots(output, boots, material);
    }

    protected static void helmet(RecipeOutput output, ItemLike helmet, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('#'), material).pattern("###").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(helmet, material));
    }

    protected static void helmet(RecipeOutput output, ItemLike helmet, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).define(Character.valueOf('#'), material).pattern("###").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(helmet, material));
    }

    protected static void chestplate(RecipeOutput output, ItemLike chestplate, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('#'), material).pattern("# #").pattern("###").pattern("###").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(chestplate, material));
    }

    protected static void chestplate(RecipeOutput output, ItemLike chestplate, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).define(Character.valueOf('#'), material).pattern("# #").pattern("###").pattern("###").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(chestplate, material));
    }

    protected static void leggings(RecipeOutput output, ItemLike leggings, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('#'), material).pattern("###").pattern("# #").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(leggings, material));
    }

    protected static void leggings(RecipeOutput output, ItemLike leggings, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).define(Character.valueOf('#'), material).pattern("###").pattern("# #").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(leggings, material));
    }

    protected static void boots(RecipeOutput output, ItemLike boots, ItemLike material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('#'), material).pattern("# #").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(boots, material));
    }

    protected static void boots(RecipeOutput output, ItemLike boots, TagKey<Item> material) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).define(Character.valueOf('#'), material).pattern("# #").pattern("# #").unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(boots, material));
    }

    protected static void fourConversion(RecipeOutput output, RecipeCategory category, ItemLike to, int count, ItemLike from) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)to, (int)count).define(Character.valueOf('#'), from).pattern("##").pattern("##").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)from), ExtendedRecipeProvider.has((ItemLike)from)).save(output, ExtendedRecipeProvider.recipeID(to, from));
    }

    protected static void nineBlockStorage(RecipeOutput output, RecipeCategory category, ItemLike unpacked, ItemLike packed) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)unpacked, (int)9).requires(packed).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)packed), ExtendedRecipeProvider.has((ItemLike)packed)).save(output, ExtendedRecipeProvider.recipeID(unpacked, packed));
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)unpacked), ExtendedRecipeProvider.has((ItemLike)unpacked)).save(output, ExtendedRecipeProvider.recipeID(packed, unpacked));
    }

    protected static void combine(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike block, ItemLike moss) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result).requires(block).requires(moss).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)block), ExtendedRecipeProvider.has((ItemLike)block)).save(output, ExtendedRecipeProvider.recipeID(result, block));
    }

    protected static void combine(RecipeOutput output, RecipeCategory category, ItemLike result, TagKey<Item> block, TagKey<Item> moss) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result).requires(block).requires(moss).unlockedBy(ExtendedRecipeProvider.getHasName(block), ExtendedRecipeProvider.has(block)).save(output, ExtendedRecipeProvider.recipeID(result, block));
    }

    protected static void dying(RecipeOutput output, TagKey<Item> dyedItems, String idPattern, String group) {
        for (DyeColor dye : DyeColor.values()) {
            ResourceLocation resultID = ExtendedRecipeProvider.locate(idPattern.replace("{color}", dye.getName()));
            ResourceLocation dyeID = ResourceLocation.withDefaultNamespace((String)(dye.getName() + "_dye"));
            Item result = (Item)BuiltInRegistries.ITEM.get(resultID);
            Item dyeItem = (Item)BuiltInRegistries.ITEM.get(dyeID);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires(dyedItems).requires((ItemLike)dyeItem).group(group).unlockedBy("has_needed_dye", ExtendedRecipeProvider.has((ItemLike)dyeItem)).save(output, ExtendedRecipeProvider.locate("dye_" + ExtendedRecipeProvider.getItemName((ItemLike)result)));
        }
    }

    protected static void oreSmelting(RecipeOutput output, ItemLike ingot, ItemLike raw) {
        ExtendedRecipeProvider.smelting(output, RecipeCategory.MISC, ingot, raw, 0.7f, 200);
        ExtendedRecipeProvider.blasting(output, RecipeCategory.MISC, ingot, raw, 0.7f, 100);
    }

    protected static void oreSmelting(RecipeOutput output, ItemLike ingot, TagKey<Item> raw) {
        ExtendedRecipeProvider.smelting(output, RecipeCategory.MISC, ingot, raw, 0.7f, 200);
        ExtendedRecipeProvider.blasting(output, RecipeCategory.MISC, ingot, raw, 0.7f, 100);
    }

    protected static void stoneSmelting(RecipeOutput output, ItemLike ingot, TagKey<Item> raw) {
        ExtendedRecipeProvider.smelting(output, RecipeCategory.BUILDING_BLOCKS, ingot, raw, 0.1f, 200);
    }

    protected static void stoneSmelting(RecipeOutput output, ItemLike ingot, ItemLike raw) {
        ExtendedRecipeProvider.smelting(output, RecipeCategory.BUILDING_BLOCKS, ingot, raw, 0.1f, 200);
    }

    protected static void shapeless(RecipeOutput output, RecipeCategory category, ItemLike result, int countR, ItemLike material, int countM) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)countR).requires(material, countM).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.recipeID(result, material));
    }

    protected static void shapeless(RecipeOutput output, RecipeCategory category, ItemLike result, int countR, TagKey<Item> material, int countM) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)countR).requires(Ingredient.of(material), countM).unlockedBy(ExtendedRecipeProvider.getHasName(material), ExtendedRecipeProvider.has(material)).save(output, ExtendedRecipeProvider.recipeID(result, material));
    }

    protected static void stonecutting(RecipeOutput output, RecipeCategory category, ItemLike result, int count, ItemLike material) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)category, (ItemLike)result, (int)count).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)material), ExtendedRecipeProvider.has((ItemLike)material)).save(output, ExtendedRecipeProvider.stonecuttingRecipeID(result, material));
    }

    protected static void smelting(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)ingredient), ExtendedRecipeProvider.has((ItemLike)ingredient)).save(output, ExtendedRecipeProvider.smeltingRecipeID(result, ingredient));
    }

    protected static void smelting(RecipeOutput output, RecipeCategory category, ItemLike result, TagKey<Item> ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName(ingredient), ExtendedRecipeProvider.has(ingredient)).save(output, ExtendedRecipeProvider.smeltingRecipeID(result, ingredient));
    }

    protected static void blasting(RecipeOutput output, RecipeCategory category, ItemLike result, ItemLike ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)ingredient), ExtendedRecipeProvider.has((ItemLike)ingredient)).save(output, ExtendedRecipeProvider.blastingRecipeID(result, ingredient));
    }

    protected static void blasting(RecipeOutput output, RecipeCategory category, ItemLike result, TagKey<Item> ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName(ingredient), ExtendedRecipeProvider.has(ingredient)).save(output, ExtendedRecipeProvider.blastingRecipeID(result, ingredient));
    }

    protected static void smoking(RecipeOutput output, ItemLike result, ItemLike ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName((ItemLike)ingredient), ExtendedRecipeProvider.has((ItemLike)ingredient)).save(output, ExtendedRecipeProvider.smokingRecipeID(result, ingredient));
    }

    protected static void smoking(RecipeOutput output, ItemLike result, TagKey<Item> ingredient, float xp, int time) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)time).unlockedBy(ExtendedRecipeProvider.getHasName(ingredient), ExtendedRecipeProvider.has(ingredient)).save(output, ExtendedRecipeProvider.smokingRecipeID(result, ingredient));
    }

    protected static ResourceLocation recipeID(ItemLike result, ItemLike material) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.locate(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate(ExtendedRecipeProvider.getConversionRecipeName(itemID, material));
        }
        return recipeID;
    }

    protected static ResourceLocation recipeID(ItemLike result, TagKey<Item> material) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.locate(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate(ExtendedRecipeProvider.getConversionRecipeName(itemID, material));
        }
        return recipeID;
    }

    protected static ResourceLocation stonecuttingRecipeID(String key) {
        return ExtendedRecipeProvider.locate("stonecutting/" + key);
    }

    protected static ResourceLocation stonecuttingRecipeID(ItemLike result, ItemLike ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.stonecuttingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("stonecutting/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation smeltingRecipeID(String key) {
        return ExtendedRecipeProvider.locate("smelting/" + key);
    }

    protected static ResourceLocation smeltingRecipeID(ItemLike result, ItemLike ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.smeltingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("smelting/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation smeltingRecipeID(ItemLike result, TagKey<Item> ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.smeltingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("smelting/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation blastingRecipeID(String key) {
        return ExtendedRecipeProvider.locate("blasting/" + key);
    }

    protected static ResourceLocation blastingRecipeID(ItemLike result, ItemLike ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.blastingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("blasting/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation blastingRecipeID(ItemLike result, TagKey<Item> ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.blastingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("blasting/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation smokingRecipeID(String key) {
        return ExtendedRecipeProvider.locate("smoking/" + key);
    }

    protected static ResourceLocation smokingRecipeID(ItemLike result, ItemLike ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.smokingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("smoking/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static ResourceLocation smokingRecipeID(ItemLike result, TagKey<Item> ingredient) {
        String itemID = ExtendedRecipeProvider.getItemName((ItemLike)result);
        ResourceLocation recipeID = ExtendedRecipeProvider.smokingRecipeID(itemID);
        if (_recipes.contains(recipeID)) {
            return ExtendedRecipeProvider.locate("smoking/" + ExtendedRecipeProvider.getConversionRecipeName(itemID, ingredient));
        }
        return recipeID;
    }

    protected static String getConversionRecipeName(String result, ItemLike ingredient) {
        return result + "_from_" + ExtendedRecipeProvider.getItemName((ItemLike)ingredient);
    }

    protected static String getConversionRecipeName(String result, TagKey<Item> ingredient) {
        return result + "_from_" + ExtendedRecipeProvider.getItemTagName(ingredient);
    }

    protected static String getHasName(TagKey<Item> tag) {
        return "has_" + tag.location().getPath().replace('/', '_');
    }

    protected static String getItemTagName(TagKey<Item> tag) {
        return tag.location().getPath().replace('/', '_');
    }

    protected static ResourceLocation locate(String key) {
        if (key.contains(":")) {
            return ResourceLocation.bySeparator((String)key, (char)':');
        }
        return ResourceLocation.fromNamespaceAndPath((String)currentModID, (String)key);
    }
}

