/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider;

import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.ItemTagProviderRule;
import com.ametrinstudios.ametrin.world.item.CustomBoatItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public abstract class ExtendedItemTagsProvider
extends ItemTagsProvider {
    protected ArrayList<Item> excludedItems = new ArrayList();
    protected ArrayList<ItemTagProviderRule> itemTagProviderRules = new ArrayList();

    public ExtendedItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, blockTagProvider, modId, existingFileHelper);
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof AxeItem) {
                this.tag(ItemTags.AXES).add((Object)item);
            } else if (item instanceof PickaxeItem) {
                this.tag(ItemTags.PICKAXES).add((Object)item);
            } else if (item instanceof SwordItem) {
                this.tag(ItemTags.SWORDS).add((Object)item);
            } else if (item instanceof ShovelItem) {
                this.tag(ItemTags.SHOVELS).add((Object)item);
            } else if (item instanceof HoeItem) {
                this.tag(ItemTags.HOES).add((Object)item);
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof CustomBoatItem) {
                CustomBoatItem boat = (CustomBoatItem)item;
                if (boat.isChestBoat()) {
                    this.tag(ItemTags.CHEST_BOATS).add((Object)item);
                } else {
                    this.tag(ItemTags.BOATS).add((Object)item);
                }
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof SignItem) {
                this.tag(ItemTags.SIGNS).add((Object)item);
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                switch (armorItem.getEquipmentSlot()) {
                    case HEAD: {
                        this.tag(ItemTags.HEAD_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case CHEST: {
                        this.tag(ItemTags.CHEST_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case LEGS: {
                        this.tag(ItemTags.LEG_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case FEET: {
                        this.tag(ItemTags.FOOT_ARMOR).add((Object)armorItem);
                    }
                }
            }
        });
    }

    public ExtendedItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Item>> itemTagProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, itemTagProvider, blockTagProvider, modId, existingFileHelper);
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof AxeItem) {
                this.tag(ItemTags.AXES).add((Object)item);
            } else if (item instanceof PickaxeItem) {
                this.tag(ItemTags.PICKAXES).add((Object)item);
            } else if (item instanceof SwordItem) {
                this.tag(ItemTags.SWORDS).add((Object)item);
            } else if (item instanceof ShovelItem) {
                this.tag(ItemTags.SHOVELS).add((Object)item);
            } else if (item instanceof HoeItem) {
                this.tag(ItemTags.HOES).add((Object)item);
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof CustomBoatItem) {
                CustomBoatItem boat = (CustomBoatItem)item;
                if (boat.isChestBoat()) {
                    this.tag(ItemTags.CHEST_BOATS).add((Object)item);
                } else {
                    this.tag(ItemTags.BOATS).add((Object)item);
                }
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof SignItem) {
                this.tag(ItemTags.SIGNS).add((Object)item);
            }
        });
        this.itemTagProviderRules.add((item, name) -> {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                switch (armorItem.getEquipmentSlot()) {
                    case HEAD: {
                        this.tag(ItemTags.HEAD_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case CHEST: {
                        this.tag(ItemTags.CHEST_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case LEGS: {
                        this.tag(ItemTags.LEG_ARMOR).add((Object)armorItem);
                        break;
                    }
                    case FEET: {
                        this.tag(ItemTags.FOOT_ARMOR).add((Object)armorItem);
                    }
                }
            }
        });
    }

    protected abstract void addTags(@NotNull HolderLookup.Provider var1);

    protected void runRules(DeferredRegister.Items register) {
        this.runRules(register.getEntries().stream().map(Supplier::get).iterator());
    }

    protected void runRules(Iterator<? extends Item> items) {
        items.forEachRemaining(item -> {
            if (this.excludedItems.contains(item)) {
                return;
            }
            String name = DataProviderExtensions.getItemName(item);
            for (ItemTagProviderRule rule : this.itemTagProviderRules) {
                rule.run((Item)item, name);
            }
        });
    }
}

