/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider;

import com.ametrinstudios.ametrin.data.BlockItemModelProviderRule;
import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.ItemModelProviderRule;
import com.ametrinstudios.ametrin.world.item.CustomHeadBlockItem;
import com.ametrinstudios.ametrin.world.item.ItemNameDoubleHighBlockItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;

public abstract class ExtendedItemModelProvider
extends ItemModelProvider {
    protected final ModelFile generated = this.getExistingFile(this.mcLoc("item/generated"));
    private final ModelFile spawnEgg = this.getExistingFile(this.mcLoc("item/template_spawn_egg"));
    protected final ModelFile handheld = this.getExistingFile(this.mcLoc("item/handheld"));
    public ArrayList<Item> excludedItems = new ArrayList();
    public ArrayList<Class<? extends Item>> excludedClasses = new ArrayList();
    public ArrayList<BlockItem> useItemModel = new ArrayList();
    public ArrayList<BlockItem> useItemModelWithBlockTexture = new ArrayList();
    public ArrayList<ItemModelProviderRule> priorityItemModelProviderRules = new ArrayList();
    public ArrayList<ItemModelProviderRule> itemModelProviderRules = new ArrayList();
    public ArrayList<BlockItemModelProviderRule> blockItemModelProviderRules = new ArrayList();

    public ExtendedItemModelProvider(PackOutput output, String modID, ExistingFileHelper existingFileHelper) {
        super(output, modID, existingFileHelper);
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof WallBlock)) {
                return false;
            }
            texture = DataProviderExtensions.shouldAppendS(name) ? texture.replace("_wall", "s") : (name.contains("sandstone") && name.contains("smooth") ? texture.replace("wall", "top").replace("smooth_", "") : texture.replace("_wall", ""));
            this.wallInventory(name, this.modBlockLoc(texture));
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof DoublePlantBlock)) {
                return false;
            }
            this.blockItem(name, texture + "_top");
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof BushBlock) && !(block instanceof GrowingPlantHeadBlock)) {
                return false;
            }
            this.blockItem(name, texture);
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof FenceBlock)) {
                return false;
            }
            texture = DataProviderExtensions.isPlank(name) ? texture.replace("fence", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_fence", "s") : texture.replace("_fence", ""));
            this.fenceInventory(name, this.modBlockLoc(texture));
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof ButtonBlock)) {
                return false;
            }
            if (DataProviderExtensions.isWooden(name)) {
                this.buttonInventory(name, this.modBlockLoc(name.replace("button", "planks")));
                return true;
            }
            texture = DataProviderExtensions.shouldAppendS(name) ? texture.replace("_button", "s") : texture.replace("_button", "");
            this.buttonInventory(name, this.modBlockLoc(texture));
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof TrapDoorBlock)) {
                return false;
            }
            this.block(name, name + "_bottom");
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof CampfireBlock || block instanceof LanternBlock || block instanceof DoorBlock)) {
                return false;
            }
            this.item(name, texture);
            return true;
        });
        this.blockItemModelProviderRules.add((item, block, name, texture) -> {
            if (!(block instanceof TorchBlock)) {
                return false;
            }
            this.blockItem(name, texture);
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof CustomHeadBlockItem)) {
                return false;
            }
            this.block(name, name + "/0");
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof SignItem)) {
                return false;
            }
            this.item(name, texture);
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof DoubleHighBlockItem)) {
                return false;
            }
            this.item(name, texture + "_top");
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof BlockItem) || item instanceof ItemNameBlockItem || item instanceof ItemNameDoubleHighBlockItem) {
                return false;
            }
            Block block = ((BlockItem)item).getBlock();
            for (BlockItemModelProviderRule provider : this.blockItemModelProviderRules) {
                if (!provider.generate(item, block, name, texture)) continue;
                return true;
            }
            if (this.useItemModel.contains(item)) {
                this.item(name, texture);
                return true;
            }
            if (this.useItemModelWithBlockTexture.contains(item)) {
                this.blockItem(name);
                return true;
            }
            this.block(name);
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof TieredItem)) {
                return false;
            }
            this.item(name, this.handheld, texture);
            return true;
        });
        this.itemModelProviderRules.add((item, name, texture) -> {
            if (!(item instanceof SpawnEggItem)) {
                return false;
            }
            ((ItemModelBuilder)this.getBuilder(name)).parent(this.spawnEgg);
            return true;
        });
    }

    protected void runProviderRules(DeferredRegister.Items itemRegister) {
        this.runProviderRules(itemRegister.getEntries().stream().map(Supplier::get).iterator());
    }

    protected void runProviderRules(Iterator<? extends Item> items) {
        items.forEachRemaining(item -> {
            for (Class<? extends Item> clazz : this.excludedClasses) {
                if (!clazz.isInstance(item)) continue;
                return;
            }
            if (this.excludedItems.contains(item)) {
                return;
            }
            String name = DataProviderExtensions.getItemName(item);
            String texture = this.getTexture(name);
            for (ItemModelProviderRule provider : this.priorityItemModelProviderRules) {
                if (!provider.generate((Item)item, name, texture)) continue;
                return;
            }
            for (ItemModelProviderRule provider : this.itemModelProviderRules) {
                if (!provider.generate((Item)item, name, texture)) continue;
                return;
            }
            this.item(name, texture);
        });
    }

    protected void item(String name, String texture) {
        this.item(name, this.generated, texture);
    }

    protected void item(String name, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(parent)).texture("layer0", this.modItemLoc(texture));
    }

    protected void blockItem(String name) {
        this.blockItem(name, name);
    }

    protected void blockItem(String name, String texture) {
        this.blockItem(name, this.generated, texture);
    }

    protected void blockItem(String name, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent(parent)).texture("layer0", this.modBlockLoc(texture));
    }

    protected void block(String name) {
        this.block(name, name);
    }

    protected void block(String name, String parent) {
        this.withExistingParent(this.itemLoc(name), this.modBlockLoc(parent));
    }

    protected ResourceLocation modBlockLoc(String key) {
        return this.modLoc(this.blockLoc(key));
    }

    protected ResourceLocation modItemLoc(String key) {
        return this.modLoc(this.itemLoc(key));
    }

    protected String itemLoc(String key) {
        return "item/" + key;
    }

    protected String blockLoc(String key) {
        return "block/" + key;
    }

    protected String getTexture(String name) {
        return name;
    }
}

