/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider;

import com.ametrinstudios.ametrin.data.BlockTagProviderRule;
import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendedBlockTagsProvider
extends BlockTagsProvider {
    public ArrayList<Block> excludedBlocks = new ArrayList();
    public ArrayList<BlockTagProviderRule> blockTagProviderRules = new ArrayList();

    public ExtendedBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modID, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, registries, modID, existingFileHelper);
    }

    protected void runRules(DeferredRegister.Blocks blockRegistry) {
        this.runRules(blockRegistry.getEntries().stream().map(Supplier::get).iterator());
    }

    protected void runRules(Iterator<? extends Block> blocks) {
        blocks.forEachRemaining(block -> {
            if (this.excludedBlocks.contains(block)) {
                return;
            }
            String name = DataProviderExtensions.getBlockName(block);
            for (BlockTagProviderRule provider : this.blockTagProviderRules) {
                provider.generate((Block)block, name);
            }
            if (block instanceof StairBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_STAIRS).add(block);
                } else {
                    this.tag(BlockTags.STAIRS).add(block);
                }
            }
            if (block instanceof SlabBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_SLABS).add(block);
                } else {
                    this.tag(BlockTags.SLABS).add(block);
                }
            }
            if (block instanceof WallBlock) {
                this.tag(BlockTags.WALLS).add(block);
            }
            if (block instanceof FenceBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_FENCES).add(block);
                    this.tag(Tags.Blocks.FENCES_WOODEN).add(block);
                } else {
                    this.tag(BlockTags.FENCES).add(block);
                    this.tag(Tags.Blocks.FENCES).add(block);
                }
            }
            if (block instanceof FenceGateBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add(block);
                } else {
                    this.tag(BlockTags.FENCE_GATES).add(block);
                    this.tag(Tags.Blocks.FENCE_GATES).add(block);
                }
            }
            if (block instanceof ButtonBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_BUTTONS).add(block);
                } else {
                    this.tag(BlockTags.BUTTONS).add(block);
                }
            }
            if (block instanceof PressurePlateBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add(block);
                } else {
                    this.tag(BlockTags.STONE_PRESSURE_PLATES).add(block);
                }
            }
            if (block instanceof DoorBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_DOORS).add(block);
                } else {
                    this.tag(BlockTags.DOORS).add(block);
                }
            }
            if (block instanceof TrapDoorBlock) {
                if (DataProviderExtensions.isWooden(name)) {
                    this.tag(BlockTags.WOODEN_TRAPDOORS).add(block);
                } else {
                    this.tag(BlockTags.TRAPDOORS).add(block);
                }
            }
            if (block instanceof FlowerPotBlock) {
                this.tag(BlockTags.FLOWER_POTS).add(block);
            }
            if (block instanceof LeavesBlock) {
                this.tag(BlockTags.LEAVES).add(block);
            }
            if (block instanceof SaplingBlock) {
                this.tag(BlockTags.SAPLINGS).add(block);
            }
            if (block instanceof FireBlock) {
                this.tag(BlockTags.FIRE).add(block);
            }
            if (block instanceof FlowerBlock) {
                this.tag(BlockTags.SMALL_FLOWERS).add(block);
            }
            if (block instanceof CampfireBlock) {
                this.tag(BlockTags.CAMPFIRES).add(block);
            }
            if (name.contains("planks")) {
                this.tag(BlockTags.PLANKS).add(block);
            }
            if (block instanceof StandingSignBlock) {
                this.tag(BlockTags.STANDING_SIGNS).add(block);
            }
            if (block instanceof WallSignBlock) {
                this.tag(BlockTags.WALL_SIGNS).add(block);
            }
            if (block instanceof CeilingHangingSignBlock) {
                this.tag(BlockTags.CEILING_HANGING_SIGNS).add(block);
            }
            if (block instanceof WallHangingSignBlock) {
                this.tag(BlockTags.WALL_HANGING_SIGNS).add(block);
            }
            if (block instanceof CauldronBlock) {
                this.tag(BlockTags.CAULDRONS).add(block);
            }
            if (block.defaultBlockState().canBeReplaced()) {
                this.tag(BlockTags.REPLACEABLE).add(block);
            }
        });
    }

    @SafeVarargs
    protected final void tag(ResourceKey<Block> block, TagKey<Block> ... tags) {
        for (TagKey<Block> key : tags) {
            this.tag(key).add(block);
        }
    }
}

