/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data.provider;

import com.ametrinstudios.ametrin.Ametrin;
import com.ametrinstudios.ametrin.data.BlockStateProviderRule;
import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.world.block.AbstractHeadBlock;
import com.ametrinstudios.ametrin.world.block.AgeableBushBlock;
import com.ametrinstudios.ametrin.world.block.AgeableDoublePlantBlock;
import com.ametrinstudios.ametrin.world.block.CustomHeadBlock;
import com.ametrinstudios.ametrin.world.block.CustomWallHeadBlock;
import com.ametrinstudios.ametrin.world.block.IAgeablePlant;
import com.ametrinstudios.ametrin.world.block.PortalBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredRegister;

public abstract class ExtendedBlockStateProvider
extends BlockStateProvider {
    public ArrayList<Block> excludedBlocks = new ArrayList();
    public ArrayList<Class<? extends Block>> excludedClasses = new ArrayList();
    public ArrayList<BlockStateProviderRule> blockStateProviderRules = new ArrayList();
    public ArrayList<Block> useCutoutRendererType = new ArrayList();

    public ExtendedBlockStateProvider(PackOutput output, String modID, ExistingFileHelper existingFileHelper) {
        super(output, modID, existingFileHelper);
        this.excludedClasses.add(SignBlock.class);
        this.excludedClasses.add(BaseFireBlock.class);
        this.excludedClasses.add(AgeableDoublePlantBlock.class);
    }

    protected String getTextureLocation(String name) {
        return name;
    }

    protected void runProviderRules(DeferredRegister.Blocks blockRegistry) {
        this.runProviderRules(blockRegistry.getEntries().stream().map(Supplier::get).iterator());
    }

    protected <B extends Block> void runProviderRules(Iterator<B> blocks) {
        blocks.forEachRemaining(block -> {
            for (Class<? extends Block> clazz : this.excludedClasses) {
                if (!clazz.isInstance(block)) continue;
                return;
            }
            if (this.excludedBlocks.contains(block)) {
                return;
            }
            String name = DataProviderExtensions.getBlockName(block);
            String texture = this.getTextureLocation(name);
            for (BlockStateProviderRule provider : this.blockStateProviderRules) {
                if (!provider.generate((Block)block, name, texture)) continue;
                return;
            }
            if (block instanceof StairBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("stairs", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_stairs", "s") : texture.replace("_stairs", ""));
                this.stairsBlock((StairBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof SlabBlock) {
                String doubleSlab = name;
                if (DataProviderExtensions.isPlank(name)) {
                    texture = texture.replace("slab", "planks");
                    doubleSlab = doubleSlab.replace("slab", "planks");
                } else if (DataProviderExtensions.shouldAppendS(name)) {
                    texture = texture.replace("_slab", "s");
                    doubleSlab = doubleSlab.replace("_slab", "s");
                } else {
                    texture = texture.replace("_slab", "");
                    doubleSlab = doubleSlab.replace("_slab", "");
                }
                this.slabBlock((SlabBlock)block, this.modBlockLoc(doubleSlab), this.modBlockLoc(texture));
            } else if (block instanceof WallBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("wall", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_wall", "s") : texture.replace("_wall", ""));
                this.wallBlock((WallBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof RotatedPillarBlock) {
                if (DataProviderExtensions.isLog(name)) {
                    this.logBlock((RotatedPillarBlock)block);
                } else if (DataProviderExtensions.isWood(name)) {
                    texture = texture.replace("wood", "log").replace("hyphae", "stem");
                    this.axisBlock((RotatedPillarBlock)block, this.modBlockLoc(texture), this.modBlockLoc(texture));
                }
            } else if (block instanceof FenceBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("fence", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_fence", "s") : texture.replace("_fence", ""));
                this.fenceBlock((FenceBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof FenceGateBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("fence_gate", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_fence_gate", "s") : texture.replace("_fence_gate", ""));
                this.fenceGateBlock((FenceGateBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof ButtonBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("button", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_button", "s") : texture.replace("_button", ""));
                this.buttonBlock((ButtonBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof PressurePlateBlock) {
                texture = DataProviderExtensions.isPlank(name) ? texture.replace("pressure_plate", "planks") : (DataProviderExtensions.shouldAppendS(name) ? texture.replace("_pressure_plate", "s") : texture.replace("_pressure_platen", ""));
                this.pressurePlateBlock((PressurePlateBlock)block, this.modBlockLoc(texture));
            } else if (block instanceof TrapDoorBlock) {
                if (this.useCutoutRendererType.contains(block)) {
                    this.trapdoorBlockWithRenderType((TrapDoorBlock)block, this.modBlockLoc(name), true, "cutout");
                } else {
                    this.trapdoorBlock((TrapDoorBlock)block, this.modBlockLoc(name), true);
                }
            } else if (block instanceof DoorBlock) {
                if (this.useCutoutRendererType.contains(block)) {
                    this.doorBlockWithRenderType((DoorBlock)block, this.modBlockLoc(name + "_bottom"), this.modBlockLoc(name + "_top"), "cutout");
                } else {
                    this.doorBlock((DoorBlock)block, this.modBlockLoc(name + "_bottom"), this.modBlockLoc(name + "_top"));
                }
            } else if (block instanceof DoublePlantBlock) {
                BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_top", "block/tinted_cross")).texture("cross", this.modBlockLoc(texture + "_top"))).renderType("cutout");
                BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", "block/tinted_cross")).texture("cross", this.modBlockLoc(texture + "_bottom"))).renderType("cutout");
                this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER ? bottom : top)).build());
            } else if (block instanceof AgeableBushBlock) {
                this.simpleAgeableBushBlock((AgeableBushBlock)block, name, texture);
            } else if (block instanceof BushBlock || block instanceof GrowingPlantBlock) {
                this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/tinted_cross")).texture("cross", this.modBlockLoc(name))).renderType("cutout"));
            } else if (block instanceof FlowerPotBlock) {
                this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(name, "block/flower_pot_cross")).texture("plant", this.modBlockLoc(texture.replace("potted_", ""))));
            } else if (block instanceof LeavesBlock) {
                this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(name, "block/leaves")).texture("all", this.modBlockLoc(texture)));
            } else if (block instanceof LanternBlock) {
                this.lanternBlock((LanternBlock)block, name, texture);
            } else if (block instanceof CampfireBlock) {
                this.campfireBlock((CampfireBlock)block, name, texture);
            } else if (block instanceof WallTorchBlock) {
                this.wallTorchBlock((WallTorchBlock)block, name, texture);
            } else if (block instanceof PortalBlock) {
                this.portalBlock((PortalBlock)((Object)block), name, texture);
            } else if (block instanceof TorchBlock) {
                this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/template_torch")).texture("torch", this.modBlockLoc(texture))).renderType("cutout"));
            } else if (block instanceof LiquidBlock) {
                this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", this.mcBlockLoc("water_still")));
            } else if (block instanceof CustomHeadBlock) {
                if (this.useCutoutRendererType.contains(block)) {
                    this.headCutout((CustomHeadBlock)((Object)block), name);
                } else {
                    this.head((CustomHeadBlock)((Object)block), name);
                }
            } else if (block instanceof CustomWallHeadBlock) {
                if (this.useCutoutRendererType.contains(block)) {
                    this.headCutoutWall((CustomWallHeadBlock)((Object)block), name);
                } else {
                    this.headWall((CustomWallHeadBlock)((Object)block), name);
                }
            } else {
                this.simpleBlock((Block)block);
            }
        });
    }

    protected void portalBlock(PortalBlock portal, String name, String texture) {
        ResourceLocation textureLoc = this.modBlockLoc(texture);
        BlockModelBuilder ew = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_ew", "nether_portal_ew")).texture("portal", textureLoc)).texture("particle", textureLoc)).renderType("translucent");
        BlockModelBuilder ns = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_ns", "nether_portal_ns")).texture("portal", textureLoc)).texture("particle", textureLoc)).renderType("translucent");
        this.getVariantBuilder(portal).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.getValue(PortalBlock.AXIS) == Direction.Axis.X ? ns : ew)).build());
    }

    protected void lanternBlock(LanternBlock lantern, String name, String texture) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/template_lantern")).texture("lantern", this.modBlockLoc(texture))).renderType("cutout");
        BlockModelBuilder modelHanging = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", "block/template_hanging_lantern")).texture("lantern", this.modBlockLoc(texture))).renderType("cutout");
        this.getVariantBuilder((Block)lantern).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.getValue((Property)LanternBlock.HANGING) != false ? modelHanging : model)).build(), new Property[]{LanternBlock.WATERLOGGED});
    }

    protected void campfireBlock(CampfireBlock campfire, String name, String texture) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/template_campfire")).texture("fire", this.modBlockLoc(texture + "_fire"))).texture("lit_log", this.modBlockLoc(texture + "_log_lit"))).renderType("cutout");
        ModelFile.ExistingModelFile modelOff = this.models().getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/campfire_off"));
        this.getVariantBuilder((Block)campfire).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)blockState.getValue((Property)CampfireBlock.LIT) != false ? model : modelOff)).rotationY(ExtendedBlockStateProvider.horizontalDirectionToYAngleForCampfire((Direction)blockState.getValue((Property)CampfireBlock.FACING))).build(), new Property[]{CampfireBlock.WATERLOGGED, CampfireBlock.SIGNAL_FIRE});
    }

    protected void wallTorchBlock(WallTorchBlock wallTorch, String name, String texture) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/template_torch_wall")).texture("torch", this.modBlockLoc(texture.replace("_wall", "")))).renderType("cutout");
        this.getVariantBuilder((Block)wallTorch).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(ExtendedBlockStateProvider.horizontalDirectionToYAngleForWallTorch((Direction)state.getValue((Property)WallTorchBlock.FACING))).build());
    }

    protected void head(CustomHeadBlock head, String name) {
        this.getVariantBuilder(head).forAllStatesExcept(state -> {
            int rotation = (Integer)state.getValue((Property)CustomHeadBlock.ROTATION);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + "/" + rotation, Ametrin.locate("block/head/" + rotation))).texture("texture", this.modBlockLoc(name));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new Property[]{AbstractHeadBlock.WATERLOGGED});
    }

    protected void headWall(CustomWallHeadBlock wallHead, String name) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, Ametrin.locate("block/head_wall"))).texture("texture", this.modBlockLoc(name.replace("_wall", "")));
        this.getVariantBuilder(wallHead).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(ExtendedBlockStateProvider.horizontalDirectionToYAngle((Direction)state.getValue((Property)CustomWallHeadBlock.FACING))).build(), new Property[]{AbstractHeadBlock.WATERLOGGED});
    }

    protected void headCutout(CustomHeadBlock head, String name) {
        this.getVariantBuilder(head).forAllStatesExcept(state -> {
            int rotation = (Integer)state.getValue((Property)CustomHeadBlock.ROTATION);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + "/" + rotation, Ametrin.locate("block/head/cutout/" + rotation))).texture("texture", this.modBlockLoc(name))).renderType("cutout");
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new Property[]{AbstractHeadBlock.WATERLOGGED});
    }

    protected void headCutoutWall(CustomWallHeadBlock wallHead, String name) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name, Ametrin.locate("block/head_wall_cutout"))).texture("texture", this.modBlockLoc(name.replace("_wall", "")))).renderType("cutout");
        this.getVariantBuilder(wallHead).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(ExtendedBlockStateProvider.horizontalDirectionToYAngle((Direction)state.getValue((Property)CustomWallHeadBlock.FACING))).build(), new Property[]{AbstractHeadBlock.WATERLOGGED});
    }

    protected void simpleAgeableBushBlock(AgeableBushBlock bush, String name, String texture) {
        BlockModelBuilder Age0 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage0", this.mcLoc("block/sweet_berry_bush_stage0"))).renderType("cutout");
        BlockModelBuilder Age1 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage1", this.mcLoc("block/sweet_berry_bush_stage1"))).renderType("cutout");
        BlockModelBuilder Age2 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage2", this.modBlockLoc(texture + "/stage2"))).renderType("cutout");
        BlockModelBuilder Age3 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage3", this.modBlockLoc(texture + "/stage3"))).renderType("cutout");
        this.getVariantBuilder((Block)bush).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)IAgeablePlant.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)(age == 0 ? Age0 : (age == 1 ? Age1 : (age == 2 ? Age2 : Age3)))).build();
        });
    }

    protected void ageableBushBlock(AgeableBushBlock bush, String name, String texture) {
        BlockModelBuilder Age0 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage0", this.modBlockLoc(texture + "/stage0"))).renderType("cutout");
        BlockModelBuilder Age1 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage1", this.modBlockLoc(texture + "/stage1"))).renderType("cutout");
        BlockModelBuilder Age2 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage2", this.modBlockLoc(texture + "/stage2"))).renderType("cutout");
        BlockModelBuilder Age3 = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + name + "/stage3", this.modBlockLoc(texture + "/stage3"))).renderType("cutout");
        this.getVariantBuilder((Block)bush).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)IAgeablePlant.AGE);
            return ConfiguredModel.builder().modelFile((ModelFile)(age == 0 ? Age0 : (age == 1 ? Age1 : (age == 2 ? Age2 : Age3)))).build();
        });
    }

    protected static int horizontalDirectionToYAngle(Direction direction) {
        return direction == Direction.NORTH ? 0 : (direction == Direction.EAST ? 90 : (direction == Direction.SOUTH ? 180 : 270));
    }

    protected static int horizontalDirectionToYAngleForWallTorch(Direction direction) {
        return direction == Direction.NORTH ? 270 : (direction == Direction.EAST ? 0 : (direction == Direction.SOUTH ? 90 : 180));
    }

    protected static int horizontalDirectionToYAngleForCampfire(Direction direction) {
        return direction == Direction.NORTH ? 270 : (direction == Direction.EAST ? 0 : (direction == Direction.SOUTH ? 90 : 180));
    }

    protected ResourceLocation modBlockLoc(String key) {
        return this.modLoc("block/" + key);
    }

    protected ResourceLocation mcBlockLoc(String key) {
        return this.mcLoc("block/" + key);
    }

    public static class RenderTypes {
        public static final String CUTOUT = "cutout";
        public static final String TRANSLUCENT = "translucent";
    }
}

