/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class LootTableProviderHelper {
    public static LootPoolEntryContainer.Builder<?> item(ItemLike item, int weight, NumberProvider amount) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount));
    }

    public static LootPoolEntryContainer.Builder<?> tag(TagKey<Item> tagKey, int weight, NumberProvider amount) {
        return TagEntry.expandTag(tagKey).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount));
    }

    public static LootPoolEntryContainer.Builder<?> enchantedItem(ItemLike item, int weight, NumberProvider enchant, NumberProvider amount, HolderLookup.Provider provider) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)provider, (NumberProvider)enchant));
    }

    public static LootPoolEntryContainer.Builder<?> enchantedItem(ItemLike item, int weight, NumberProvider amount, HolderLookup.Provider provider) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomApplicableEnchantment((HolderLookup.Provider)provider));
    }

    public static LootPoolEntryContainer.Builder<?> suspiciousStew(int weight, NumberProvider amount) {
        return LootItem.lootTableItem((ItemLike)Items.SUSPICIOUS_STEW).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)SetStewEffectFunction.stewEffect().withEffect(MobEffects.NIGHT_VISION, LootTableProviderHelper.number(7, 10)).withEffect(MobEffects.JUMP, LootTableProviderHelper.number(7, 10)).withEffect(MobEffects.WEAKNESS, LootTableProviderHelper.number(6, 8)).withEffect(MobEffects.BLINDNESS, LootTableProviderHelper.number(5, 7)).withEffect(MobEffects.POISON, LootTableProviderHelper.number(10, 20)).withEffect(MobEffects.SATURATION, LootTableProviderHelper.number(7, 10)));
    }

    public static LootPoolEntryContainer.Builder<?> potion(int weight, Holder<Potion> potion, NumberProvider amount) {
        return LootItem.lootTableItem((ItemLike)Items.POTION).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potion));
    }

    public static LootPoolEntryContainer.Builder<?> splashPotion(int weight, Holder<Potion> potion, NumberProvider amount) {
        return LootItem.lootTableItem((ItemLike)Items.SPLASH_POTION).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potion));
    }

    public static LootPoolEntryContainer.Builder<?> lingeringPotion(int weight, Holder<Potion> potion, NumberProvider amount) {
        return LootItem.lootTableItem((ItemLike)Items.LINGERING_POTION).setWeight(weight).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)amount)).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potion));
    }

    public static NumberProvider one() {
        return LootTableProviderHelper.number(1);
    }

    public static NumberProvider number(int amount) {
        return ConstantValue.exactly((float)amount);
    }

    public static NumberProvider number(int min, int max) {
        return UniformGenerator.between((float)min, (float)max);
    }

    public static LootPool.Builder pool(NumberProvider rolls) {
        return LootPool.lootPool().setRolls(rolls);
    }
}

