/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data;

import com.ametrinstudios.ametrin.data.provider.CustomLootTableProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataProviderHelper {
    public final DataGenerator generator;
    public final PackOutput output;
    public final ExistingFileHelper existingFileHelper;
    public final CompletableFuture<HolderLookup.Provider> lookupProvider;
    public final boolean includeClient;
    public final boolean includeServer;

    public DataProviderHelper(GatherDataEvent event) {
        this.generator = event.getGenerator();
        this.output = this.generator.getPackOutput();
        this.existingFileHelper = event.getExistingFileHelper();
        this.lookupProvider = event.getLookupProvider();
        this.includeClient = event.includeClient();
        this.includeServer = event.includeServer();
    }

    public void add(boolean run, DataProvider provider) {
        this.generator.addProvider(run, provider);
    }

    public void add(DataProvider provider) {
        this.add(this.includeServer, provider);
    }

    public void add(DataProviderFromOutput provider) {
        this.add(provider.build(this.output));
    }

    public void add(DataProviderFromOutputFileHelper provider) {
        this.add(provider.build(this.output, this.existingFileHelper));
    }

    public void add(DataProviderFromOutputLookup provider) {
        this.add(provider.build(this.output, this.lookupProvider));
    }

    public void add(DataProviderFromOutputLookupFileHelper provider) {
        this.add(provider.build(this.output, this.lookupProvider, this.existingFileHelper));
    }

    public void add(CustomLootTableProvider.Builder lootTableBuilder) {
        this.add((DataProvider)lootTableBuilder.build(this.output, this.lookupProvider));
    }

    public void addBlockAndItemTags(BlockTagsProvider blockTagsProvider, ItemTagsProvider itemTagsProvider) {
        TagsProvider<Block> blockTags = blockTagsProvider.build(this.output, this.lookupProvider, this.existingFileHelper);
        this.add((DataProvider)blockTags);
        this.add(itemTagsProvider.build(this.output, this.lookupProvider, blockTags.contentsGetter(), this.existingFileHelper));
    }

    public void addLootTables(Function<CustomLootTableProvider.Builder, CustomLootTableProvider.Builder> consumer) {
        CustomLootTableProvider.Builder builder = consumer.apply(CustomLootTableProvider.builder());
        this.add(builder);
    }

    @FunctionalInterface
    public static interface DataProviderFromOutput {
        public DataProvider build(PackOutput var1);
    }

    @FunctionalInterface
    public static interface DataProviderFromOutputFileHelper {
        public DataProvider build(PackOutput var1, ExistingFileHelper var2);
    }

    @FunctionalInterface
    public static interface DataProviderFromOutputLookup {
        public DataProvider build(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2);
    }

    @FunctionalInterface
    public static interface DataProviderFromOutputLookupFileHelper {
        public DataProvider build(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, ExistingFileHelper var3);
    }

    @FunctionalInterface
    public static interface BlockTagsProvider {
        public TagsProvider<Block> build(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, ExistingFileHelper var3);
    }

    @FunctionalInterface
    public static interface ItemTagsProvider {
        public DataProvider build(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, CompletableFuture<TagsProvider.TagLookup<Block>> var3, ExistingFileHelper var4);
    }
}

