/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.data;

import java.util.HashSet;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class DataProviderExtensions {
    private static final HashSet<String> plankIndicators = new HashSet();

    public static void addPlankIndicator(String indicator) {
        plankIndicators.add(indicator);
    }

    public static boolean isPlank(String name) {
        for (String indicator : plankIndicators) {
            if (!name.contains(indicator)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldAppendS(String name) {
        return name.matches(".*brick(?!s).*|.*tile(?!s).*");
    }

    public static boolean isLog(String name) {
        return name.matches(".*(log|stem).*");
    }

    public static boolean isWood(String name) {
        return name.matches(".*(wood|hyphae).*");
    }

    public static boolean isWooden(String name) {
        return DataProviderExtensions.isLog(name) || DataProviderExtensions.isWood(name) || name.contains("plank") || DataProviderExtensions.isPlank(name);
    }

    public static String getItemName(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath();
    }

    public static String getBlockName(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
    }
}

