/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.rhino.Context;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class Tags {
    public static TagKey<Item> item(ResourceLocation id) {
        return Tags.generic(id, Registries.ITEM);
    }

    public static TagKey<Block> block(ResourceLocation id) {
        return Tags.generic(id, Registries.BLOCK);
    }

    public static TagKey<Fluid> fluid(ResourceLocation id) {
        return Tags.generic(id, Registries.FLUID);
    }

    public static TagKey<EntityType<?>> entityType(ResourceLocation id) {
        return Tags.generic(id, Registries.ENTITY_TYPE);
    }

    public static TagKey<Biome> biome(ResourceLocation id) {
        return Tags.generic(id, Registries.BIOME);
    }

    public static Stream<TagKey<Item>> byItemStack(ItemStack stack) {
        return Tags.byItem(stack.getItem());
    }

    public static Stream<TagKey<Item>> byItem(Item item) {
        return Tags.forHolder(item.builtInRegistryHolder());
    }

    public static Stream<TagKey<Block>> byBlockState(BlockState state) {
        return Tags.byBlock(state.getBlock());
    }

    public static Stream<TagKey<Block>> byBlock(Block block) {
        return Tags.forHolder(block.builtInRegistryHolder());
    }

    public static Stream<TagKey<Fluid>> byFluid(Fluid fluid) {
        return Tags.forHolder(fluid.builtInRegistryHolder());
    }

    public static Stream<TagKey<EntityType<?>>> byEntity(Entity entity) {
        return Tags.byEntityType(entity.getType());
    }

    public static Stream<TagKey<EntityType<?>>> byEntityType(EntityType<?> entityType) {
        return Tags.forHolder(entityType.builtInRegistryHolder());
    }

    public static <T> Stream<TagKey<T>> forType(Context cx, T object, Registry<T> registry) {
        return registry.getResourceKey(object).flatMap(arg_0 -> registry.getHolder(arg_0)).stream().flatMap(Holder::tags);
    }

    private static <T> TagKey<T> generic(ResourceLocation id, ResourceKey<Registry<T>> registry) {
        return TagKey.create(registry, (ResourceLocation)id);
    }

    private static <T> Stream<TagKey<T>> forHolder(Holder.Reference<T> registryHolder) {
        return registryHolder.tags();
    }
}

