/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.error.EmptyRecipeComponentException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.CustomObjectRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.EitherRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.ListRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.MapRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilder;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithCodec;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.IntBounds;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.kubejs.util.TinyMap;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface RecipeComponent<T> {
    public static CustomObjectRecipeComponent builder(List<CustomObjectRecipeComponent.Key> keys) {
        return new CustomObjectRecipeComponent(keys);
    }

    public static CustomObjectRecipeComponent builder(CustomObjectRecipeComponent.Key ... keys) {
        return new CustomObjectRecipeComponent(List.of(keys));
    }

    default public RecipeKey<T> key(String name, ComponentRole role) {
        return new RecipeKey(this, name, role);
    }

    default public RecipeKey<T> inputKey(String name) {
        return this.key(name, ComponentRole.INPUT);
    }

    default public RecipeKey<T> outputKey(String name) {
        return this.key(name, ComponentRole.OUTPUT);
    }

    default public RecipeKey<T> otherKey(String name) {
        return this.key(name, ComponentRole.OTHER);
    }

    public RecipeComponentType<?> type();

    public Codec<T> codec();

    public TypeInfo typeInfo();

    default public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return false;
    }

    default public T wrap(RecipeScriptContext cx, Object from) {
        return (T)cx.cx().jsToJava(from, this.typeInfo());
    }

    default public void writeToJson(KubeRecipe recipe, RecipeComponentValue<T> cv, JsonObject json) {
        if (cv.key.names.size() >= 2) {
            for (String k : cv.key.names) {
                json.remove(k);
            }
        }
        try {
            DataResult result;
            DataResult dataResult = result = cv.key.codec.encodeStart(recipe.type.event.ops.json(), cv.value);
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success r = (DataResult.Success)dataResult2;
                    json.add(cv.key.name, (JsonElement)r.value());
                    break;
                }
                case 1: {
                    DataResult.Error r = (DataResult.Error)dataResult2;
                    ConsoleJS.SERVER.error("Failed to encode " + cv.key.name + " for recipe " + String.valueOf(recipe.id) + " from value" + String.valueOf(cv.value) + ": " + r.message(), recipe.sourceLine, null, RecipesKubeEvent.POST_SKIP_ERROR);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.error("Failed to encode " + cv.key.name + " for recipe " + String.valueOf(recipe.id) + " from value" + String.valueOf(cv.value) + ": " + String.valueOf(ex), recipe.sourceLine, ex, RecipesKubeEvent.POST_SKIP_ERROR);
        }
    }

    default public void readFromJson(KubeRecipe recipe, RecipeComponentValue<T> cv, JsonObject json) {
        JsonElement v = json.get(cv.key.name);
        if (v != null) {
            cv.value = cv.key.codec.parse(recipe.type.event.ops.json(), (Object)v).getOrThrow();
        } else if (cv.key.names.size() >= 2) {
            for (String alt : cv.key.names) {
                v = json.get(alt);
                if (v == null) continue;
                cv.value = cv.key.codec.parse(recipe.type.event.ops.json(), (Object)v).getOrThrow();
                return;
            }
        }
    }

    default public boolean matches(RecipeMatchContext cx, T value, ReplacementMatchInfo match) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    default public T replace(RecipeScriptContext cx, T original, ReplacementMatchInfo match, Object with) {
        T t;
        if (original instanceof Replaceable) {
            Replaceable r = (Replaceable)original;
            if (this.matches(cx, original, match)) {
                t = this.wrap(cx, r.replaceThisWith(cx, with));
                return t;
            }
        }
        t = original;
        return t;
    }

    default public boolean allowEmpty() {
        return false;
    }

    default public void validate(RecipeValidationContext ctx, T value) {
        if (!this.allowEmpty() && this.isEmpty(value)) {
            throw new EmptyRecipeComponentException(this, value);
        }
    }

    default public boolean isEmpty(T value) {
        return false;
    }

    default public void buildUniqueId(UniqueIdBuilder builder, T value) {
        builder.append(value.toString());
    }

    default public String toString(OpsContainer ops, T value) {
        return value.toString();
    }

    default public ListRecipeComponent<T> asList() {
        return ListRecipeComponent.create(this, false, false);
    }

    default public ListRecipeComponent<T> asListOrSelf() {
        return ListRecipeComponent.create(this, true, false);
    }

    default public ListRecipeComponent<T> asConditionalList() {
        return ListRecipeComponent.create(this, false, true);
    }

    default public ListRecipeComponent<T> asConditionalListOrSelf() {
        return ListRecipeComponent.create(this, true, true);
    }

    default public RecipeComponent<T> orSelf() {
        return this;
    }

    default public <K> RecipeComponent<TinyMap<K, T>> asMap(RecipeComponent<K> key) {
        return MapRecipeComponent.of(key, this, IntBounds.DEFAULT);
    }

    default public RecipeComponent<TinyMap<Character, T>> asPatternKey() {
        return MapRecipeComponent.patternOf(this, IntBounds.DEFAULT);
    }

    default public <O> EitherRecipeComponent<T, O> or(RecipeComponent<O> other) {
        return new EitherRecipeComponent(this, other);
    }

    default public RecipeComponent<T> withCodec(Codec<T> codec) {
        return new RecipeComponentWithCodec<T>(this, codec);
    }

    @Nullable
    @ApiStatus.Experimental
    default public RecipeComponentBuilder createBuilder() {
        return null;
    }

    default public List<?> spread(T value) {
        return List.of(value);
    }

    default public boolean isIgnored() {
        return false;
    }
}

