/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;

public record AlternativeCodec<A>(Codec<? extends A>[] codecs) implements Codec<A>
{
    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        ArrayList errors = new ArrayList();
        DataResult lastPartial = null;
        int i = 0;
        while (i < this.codecs.length) {
            Codec<? extends A> codec = this.codecs[i];
            DataResult result = codec.decode(ops, input);
            if (result.isSuccess()) {
                return result.map(vo -> Pair.of((Object)vo.getFirst(), (Object)vo.getSecond()));
            }
            if (result.hasResultOrPartial()) {
                lastPartial = result.map(vo -> Pair.of((Object)vo.getFirst(), (Object)vo.getSecond()));
            }
            int finalI = i++;
            result.error().ifPresent(e -> errors.add("[" + finalI + "]: " + e.message()));
        }
        if (lastPartial != null) {
            return lastPartial;
        }
        String combined = String.join((CharSequence)"; ", errors);
        return DataResult.error(() -> "Failed to parse any alternative codec. Errors: " + combined);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        for (Codec<? extends A> codec : this.codecs) {
            try {
                DataResult encoded = codec.encode(input, ops, prefix);
                if (!encoded.isSuccess()) continue;
                return encoded;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return DataResult.error(() -> "No alternative codec could encode value: " + String.valueOf(input));
    }
}

