/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ModFlowingFluid
extends FlowingFluid {
    @Nullable
    private final Supplier<? extends LiquidBlock> block;
    private final boolean convertsToSource;

    protected ModFlowingFluid(Properties properties, Supplier<? extends LiquidBlock> block) {
        this.block = block;
        this.convertsToSource = properties.canConvertToSource;
        this.afterInit(properties);
    }

    private void afterInit(Properties properties) {
    }

    public static Properties properties() {
        return new Properties();
    }

    protected boolean canConvertToSource(Level level) {
        return this.convertsToSource;
    }

    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected boolean canBeReplacedWith(FluidState state, BlockGetter level, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.isSame(fluidIn);
    }

    protected BlockState createLegacyBlock(FluidState state) {
        if (this.block != null) {
            return (BlockState)this.block.get().defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(ModFlowingFluid.getLegacyLevel((FluidState)state)));
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == this.getSource() || fluidIn == this.getFlowing();
    }

    public abstract Fluid getSource();

    public abstract Fluid getFlowing();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ModFluidRenderProperties createRenderProperties();

    public static final class Properties {
        public String descriptionId;
        public double motionScale = 0.014;
        public boolean canPushEntity = true;
        public boolean canSwim = true;
        public boolean canDrown = true;
        public float fallDistanceModifier = 0.5f;
        public boolean canExtinguish = false;
        public boolean supportsBoating = false;
        public boolean canConvertToSource = false;
        @Nullable
        public PathType pathType = PathType.WATER;
        @Nullable
        public PathType adjacentPathType = PathType.WATER_BORDER;
        public boolean canHydrate = false;
        public int lightLevel = 0;
        public int density = 1000;
        public int temperature = 300;
        public int viscosity = 1000;
        public Rarity rarity = Rarity.COMMON;
        public Map<String, SoundEvent> sounds;

        public Properties descriptionId(String descriptionId) {
            this.descriptionId = descriptionId;
            return this;
        }

        public Properties motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Properties setCanConvertToSource(boolean canConvertToSource) {
            this.canConvertToSource = canConvertToSource;
            return this;
        }

        public Properties canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Properties canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Properties canDrown(boolean canDrown) {
            this.canDrown = canDrown;
            return this;
        }

        public Properties fallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        public Properties canExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        public Properties supportsBoating(boolean supportsBoating) {
            this.supportsBoating = supportsBoating;
            return this;
        }

        public Properties pathType(@Nullable PathType pathType) {
            this.pathType = pathType;
            return this;
        }

        public Properties adjacentPathType(@Nullable PathType adjacentPathType) {
            this.adjacentPathType = adjacentPathType;
            return this;
        }

        public Properties sound(String soundActionId, SoundEvent sound) {
            this.sounds.put(soundActionId, sound);
            return this;
        }

        public Properties canHydrate(boolean canHydrate) {
            this.canHydrate = canHydrate;
            return this;
        }

        public Properties lightLevel(int lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public Properties density(int density) {
            this.density = density;
            return this;
        }

        public Properties temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Properties viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public Properties rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }
    }
}

