/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common;

import java.util.Random;
import java.util.function.Function;
import net.mehvahdjukaar.amendments.common.SwingAnimation;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SwayingAnimation
extends SwingAnimation {
    protected static float maxSwingAngle = 45.0f;
    protected static float minSwingAngle = 2.5f;
    protected static float maxPeriod = 25.0f;
    protected static float angleDamping = 150.0f;
    protected static float periodDamping = 100.0f;
    private int animationCounter = 800 + new Random().nextInt(80);
    private boolean inv = false;

    public SwayingAnimation(Function<BlockState, Vector3f> getRotationAxis) {
        super(getRotationAxis);
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ++this.animationCounter;
        double timer = this.animationCounter;
        if (((Boolean)pState.getValue((Property)WaterBlock.WATERLOGGED)).booleanValue()) {
            timer /= 2.0;
        }
        this.prevAngle = this.angle;
        float a = minSwingAngle;
        float k = 0.01f;
        if (timer < 800.0) {
            a = (float)Math.max((double)maxSwingAngle * Math.exp(-(timer / (double)angleDamping)), (double)minSwingAngle);
            k = (float)Math.max(Math.PI * 2 * (double)((float)Math.exp(-(timer / (double)periodDamping))), (double)0.01f);
        }
        this.angle = a * Mth.cos((float)((float)(timer / (double)maxPeriod - (double)k)));
        this.angle *= this.inv ? -1.0f : 1.0f;
    }

    @Override
    public float getAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    @Override
    public void setAngle(float angle) {
        this.angle = angle;
    }

    @Override
    public void reset() {
        this.animationCounter = 800;
    }

    @Override
    public boolean hitByEntity(Entity entity, BlockState state, BlockPos pos) {
        Vec3 mot = entity.getDeltaMovement();
        if (mot.length() > 0.05) {
            Vec3 vec;
            Vec3 norm = new Vec3(mot.x, 0.0, mot.z).normalize();
            double dot = norm.dot(vec = new Vec3(this.getRotationAxis(state)));
            if (dot != 0.0) {
                boolean bl = this.inv = dot < 0.0;
            }
            if (Math.abs(dot) > 0.4) {
                if (this.animationCounter > 10) {
                    Player p;
                    Player player = entity instanceof Player ? (p = (Player)entity) : null;
                    entity.level().playSound(player, pos, state.getSoundType().getHitSound(), SoundSource.BLOCKS, 0.75f, 1.5f);
                }
                this.animationCounter = 0;
            }
        }
        return true;
    }
}

