/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop.data.provider;

import com.ametrin.block_variants.bop.registry.BBBlocks;
import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.provider.ExtendedItemModelProvider;
import java.lang.runtime.SwitchBootstraps;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class BBItemModelProvider
extends ExtendedItemModelProvider {
    public BBItemModelProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "block_variants_bop", fileHelper);
    }

    protected void registerModels() {
        this.blocks(BBBlocks.getAllBlocks());
    }

    private void blocks(Stream<Block> blocks) {
        blocks.forEach(block -> {
            String textureName = DataProviderExtensions.getBlockName((Block)block);
            String name = DataProviderExtensions.getBlockName((Block)block);
            if (textureName.contains("_wood")) {
                textureName = textureName.replace("_wood", "_log");
            }
            Block selector0$temp = block;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WallBlock.class, FenceBlock.class, FenceGateBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    WallBlock wallBlock = (WallBlock)selector0$temp;
                    ResourceLocation texture = this.blockTexture(textureName.replace("_wall", ""));
                    this.wallInventory(name, texture);
                    break;
                }
                case 1: {
                    FenceBlock fenceBlock = (FenceBlock)selector0$temp;
                    ResourceLocation texture = DataProviderExtensions.isWood((String)name) ? this.blockTexture(textureName.replace("_fence", "")) : this.blockTexture(textureName.replace("_fence", "_planks"));
                    this.fenceInventory(name, texture);
                    break;
                }
                case 2: {
                    FenceGateBlock fenceGateBlock = (FenceGateBlock)selector0$temp;
                    ResourceLocation texture = DataProviderExtensions.isWood((String)name) ? this.blockTexture(textureName.replace("_fence_gate", "")) : this.blockTexture(textureName.replace("_fence_gate", "_planks"));
                    this.fenceGate(name, texture);
                    break;
                }
                default: {
                    this.withExistingParent(name, this.modBlockLoc(name));
                }
            }
        });
    }

    private ResourceLocation blockTexture(String texture) {
        return ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)("block/" + texture));
    }
}

