/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop.data.provider;

import com.ametrin.block_variants.bop.registry.BBBlocks;
import com.ametrin.block_variants.bop.registry.BBWoodBlocks;
import com.ametrinstudios.ametrin.data.provider.ExtendedBlockTagsProvider;
import com.barion.block_variants.registry.BVTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public final class BBBlockTagsProvider
extends ExtendedBlockTagsProvider {
    public BBBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "block_variants_bop", null);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        TagsProvider.TagAppender mineableWithAxe = this.tag(BlockTags.MINEABLE_WITH_AXE).add(BBBlocks.FLESH_STAIRS.getKey()).add(BBBlocks.FLESH_SLAB.getKey()).add(BBBlocks.FLESH_WALL.getKey()).add(BBBlocks.POROUS_FLESH_STAIRS.getKey()).add(BBBlocks.POROUS_FLESH_SLAB.getKey()).add(BBBlocks.POROUS_FLESH_WALL.getKey());
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(BBBlocks.BRIMSTONE_STAIRS.getKey()).add(BBBlocks.BRIMSTONE_SLAB.getKey()).add(BBBlocks.BRIMSTONE_WALL.getKey()).add(BBBlocks.ROSE_QUARTZ_BLOCK_STAIRS.getKey()).add(BBBlocks.ROSE_QUARTZ_BLOCK_SLAB.getKey()).add(BBBlocks.ROSE_QUARTZ_BLOCK_WALL.getKey());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender stairs = this.tag(BlockTags.STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender slabs = this.tag(BlockTags.SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender walls = this.tag(BlockTags.WALLS);
        for (DeferredHolder block : BBBlocks.REGISTER.getEntries()) {
            if (block.value() instanceof StairBlock) {
                stairs.add(block.getKey());
                continue;
            }
            if (block.value() instanceof SlabBlock) {
                slabs.add(block.getKey());
                continue;
            }
            if (!(block.value() instanceof WallBlock)) continue;
            walls.add(block.getKey());
        }
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenStairs = this.tag(BlockTags.WOODEN_STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenSlabs = this.tag(BlockTags.WOODEN_SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenWalls = this.tag(BVTags.Blocks.WOODEN_WALLS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenFences = this.tag(BlockTags.WOODEN_FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender woodenFenceGates = this.tag(BlockTags.FENCE_GATES);
        for (DeferredHolder block : BBWoodBlocks.REGISTER.getEntries()) {
            mineableWithAxe.add(block.getKey());
            if (block.value() instanceof StairBlock) {
                woodenStairs.add(block.getKey());
                continue;
            }
            if (block.value() instanceof SlabBlock) {
                woodenSlabs.add(block.getKey());
                continue;
            }
            if (block.value() instanceof WallBlock) {
                woodenWalls.add(block.getKey());
                continue;
            }
            if (block.value() instanceof FenceBlock) {
                woodenFences.add(block.getKey());
                continue;
            }
            if (!(block.value() instanceof FenceGateBlock)) continue;
            woodenFenceGates.add(block.getKey());
        }
        walls.addTag(BVTags.Blocks.WOODEN_WALLS);
    }

    private void addAll(TagKey<Block> tag, DeferredRegister<Block> register) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.tag(tag);
        for (DeferredHolder block : register.getEntries()) {
            appender.add(block.getKey());
        }
    }
}

