/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop.data.provider;

import com.ametrin.block_variants.bop.registry.BBBlocks;
import com.ametrin.block_variants.bop.registry.BBWoodBlocks;
import com.ametrinstudios.ametrin.data.DataProviderExtensions;
import com.ametrinstudios.ametrin.data.provider.ExtendedBlockStateProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class BBBlockStateProvider
extends ExtendedBlockStateProvider {
    public BBBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "block_variants_bop", existingFileHelper);
        this.blockStateProviderRules.add((block, name, texture) -> {
            if (!DataProviderExtensions.isLog((String)name)) {
                return false;
            }
            if (block instanceof StairBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("stairs", "top"));
                this.stairsBlock((StairBlock)block, this.modBlockLoc(texture.replace("_stairs", "")), top, top);
            } else if (block instanceof SlabBlock) {
                ResourceLocation top = this.modBlockLoc(texture.replace("slab", "top"));
                this.slabBlock((SlabBlock)block, this.modBlockLoc(texture.replace("_slab", "")), this.modBlockLoc(texture.replace("_slab", "")), top, top);
            } else {
                return false;
            }
            return true;
        });
    }

    protected void registerStatesAndModels() {
        this.runProviderRules(BBWoodBlocks.REGISTER);
        this.runProviderRules(BBBlocks.REGISTER);
    }

    protected String getTextureLocation(String name) {
        if (name.contains("_wood")) {
            name = name.replace("_wood", "_log");
        }
        return name;
    }

    protected ResourceLocation modBlockLoc(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)("block/" + key));
    }
}

