/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop;

import com.ametrin.block_variants.bop.data.provider.BBBlockStateProvider;
import com.ametrin.block_variants.bop.data.provider.BBBlockTagsProvider;
import com.ametrin.block_variants.bop.data.provider.BBDataMapProvider;
import com.ametrin.block_variants.bop.data.provider.BBItemModelProvider;
import com.ametrin.block_variants.bop.data.provider.BBItemTagsProvider;
import com.ametrin.block_variants.bop.data.provider.BBLanguageProvider;
import com.ametrin.block_variants.bop.data.provider.BBRecipeProvider;
import com.ametrin.block_variants.bop.data.provider.loot.BBBlockLootProvider;
import com.ametrin.block_variants.bop.registry.BBBlocks;
import com.ametrin.block_variants.bop.registry.BBCreativeModeTabs;
import com.ametrin.block_variants.bop.registry.BBItems;
import com.ametrin.block_variants.bop.registry.BBWoodBlocks;
import com.ametrinstudios.ametrin.data.provider.CustomLootTableProvider;
import com.mojang.logging.LogUtils;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;

@Mod(value="block_variants_bop")
public final class BlockVariantsBOPIntegration {
    public static final String MOD_ID = "block_variants_bop";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlockVariantsBOPIntegration(IEventBus modBus, ModContainer modContainer) {
        BBBlocks.REGISTER.register(modBus);
        BBWoodBlocks.REGISTER.register(modBus);
        BBItems.REGISTER.register(modBus);
        BBCreativeModeTabs.REGISTER.register(modBus);
        modBus.addListener(BlockVariantsBOPIntegration::gatherData);
    }

    private static void gatherData(GatherDataEvent event) {
        event.createProvider(output -> new BBBlockStateProvider(output, event.getExistingFileHelper()));
        event.createProvider(output -> new BBItemModelProvider(output, event.getExistingFileHelper()));
        event.createProvider(BBRecipeProvider::new);
        event.createProvider(BBLanguageProvider::new);
        event.createProvider(BBDataMapProvider::new);
        event.createBlockAndItemTags(BBBlockTagsProvider::new, BBItemTagsProvider::new);
        event.createProvider((arg_0, arg_1) -> ((CustomLootTableProvider.Builder)CustomLootTableProvider.builder().addBlockProvider(BBBlockLootProvider::new)).build(arg_0, arg_1));
    }
}

