/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.client.ClientComputer;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public class ComputerMenu
extends SimpleContainerMenu
implements IElectricityMenu {
    private final ContainerData data;
    private final IComputer computer;
    private ContainerListener changeListener;

    public ComputerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, (ContainerData)new SimpleContainerData(4), new ClientComputer(data.m_130135_(), playerInventory.f_35978_));
    }

    public ComputerMenu(int windowId, Inventory playerInventory, ContainerData data, IComputer computer) {
        super((MenuType)ModMenuTypes.COMPUTER.get(), windowId, (Container)new SimpleContainer(0));
        ComputerMenu.m_38886_((ContainerData)data, (int)4);
        this.data = data;
        this.computer = computer;
        this.m_38884_(data);
        computer.setUser(playerInventory.f_35978_);
    }

    public IComputer getComputer() {
        return this.computer;
    }

    public void setChangeListener(ContainerListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.computer.setUser(null);
    }

    @Override
    public boolean m_6875_(Player player) {
        return this.computer.isValid(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        return ItemStack.f_41583_;
    }

    public void m_7511_(int dataIndex, int dataValue) {
        boolean changed = this.data.m_6413_(dataIndex) != dataValue;
        super.m_7511_(dataIndex, dataValue);
        if (changed && this.changeListener != null) {
            this.changeListener.m_142153_((AbstractContainerMenu)this, dataIndex, dataValue);
        }
    }

    public boolean getPowerState() {
        return (this.data.m_6413_(1) & 0xF) > 0;
    }

    public void setProgramData(long data) {
        this.data.m_8050_(2, (int)(data >> 32));
        this.data.m_8050_(3, (int)data);
    }

    public long getProgramData() {
        int programData1 = this.data.m_6413_(2);
        int programData2 = this.data.m_6413_(3);
        return (long)programData1 << 32 | (long)programData2 & 0xFFFFFFFFL;
    }

    @Override
    public boolean isPowered() {
        return this.data.m_6413_(0) != 0;
    }
}

