/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BathBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BathBlock.DIRECTION)) {
            Direction direction = (Direction)state.m_61143_((Property)BathBlock.DIRECTION);
            Level level = Objects.requireNonNull(this.f_58857_);
            BlockEntity blockEntity = level.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)blockEntity;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(BlockState state) {
        if (state.m_61138_(BathBlock.TYPE) && state.m_61143_(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.m_6596_();
                container.sync(this);
            });
        }
        return null;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return InteractionResult.CONSUME;
        }
        if (this.interactWithBottle(player, hand, this.f_58858_).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.performPlatformInteraction(player, hand, this.f_58858_, result.m_82434_()).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && result.m_82434_() != Direction.DOWN) {
            if (this.tryAndFillWithFluid(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82512_((Vec3i)this.f_58858_)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryAndCreateObsidian(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82539_((Vec3i)this.f_58858_).m_82520_(0.0, 1.0, 0.0)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        } else {
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)BathBlock.DIRECTION)) {
                BathBlockEntity bath;
                BlockEntity blockEntity;
                BlockPos headPos = this.f_58858_.m_121945_((Direction)state.m_61143_((Property)BathBlock.DIRECTION));
                if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(headPos)) instanceof BathBlockEntity && (bath = (BathBlockEntity)blockEntity).isHead()) {
                    bath.playWaterAnimation();
                }
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            Vec3 tap = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.m_231075_((Direction)state.m_61143_((Property)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.f_82479_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                double z = tap.f_82481_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                level.m_7106_((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.f_82480_, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.tank != null) {
            this.tank.load(tag.m_128469_("FluidTank"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.tank != null) {
            CompoundTag tankTag = new CompoundTag();
            this.tank.save(tankTag);
            tag.m_128365_("FluidTank", (Tag)tankTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

