/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public interface IMagicSummon
extends AntiMagicSusceptible {
    default public Entity getSummoner() {
        return SummonManager.getOwner((Entity)this);
    }

    public void onUnSummon();

    @Override
    default public void onAntiMagic(MagicData playerMagicData) {
        this.onUnSummon();
    }

    default public boolean shouldIgnoreDamage(DamageSource damageSource) {
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && !((Boolean)ServerConfigs.CAN_ATTACK_OWN_SUMMONS.get()).booleanValue() && damageSource.m_7639_() != null) {
            return DamageSources.isFriendlyFireBetween(damageSource.m_7639_(), (Entity)this);
        }
        return false;
    }

    default public boolean isAlliedHelper(Entity entity) {
        Entity owner = this.getSummoner();
        if (owner == null) {
            return false;
        }
        if (entity instanceof IMagicSummon) {
            IMagicSummon magicSummon = (IMagicSummon)entity;
            Entity otherOwner = magicSummon.getSummoner();
            return otherOwner != null && (owner == otherOwner || otherOwner.m_7307_(otherOwner));
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity tamableAnimal = (OwnableEntity)entity;
            LivingEntity otherOwner = tamableAnimal.m_269323_();
            return otherOwner != null && (owner == otherOwner || otherOwner.m_7307_((Entity)otherOwner));
        }
        return false;
    }

    default public void onDeathHelper() {
        IMagicSummon iMagicSummon = this;
        if (iMagicSummon instanceof LivingEntity) {
            Entity entity;
            LivingEntity entity2 = (LivingEntity)iMagicSummon;
            Level level = entity2.f_19853_;
            Component deathMessage = entity2.m_21231_().m_19293_();
            if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46142_) && (entity = this.getSummoner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.m_213846_(deathMessage);
            }
        }
    }

    default public void onRemovedHelper(Entity entity) {
        Entity entity2;
        if (entity.f_19853_.f_46443_) {
            return;
        }
        Entity.RemovalReason reason = entity.m_146911_();
        if (reason == null || reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            // empty if block
        }
        if (reason == Entity.RemovalReason.DISCARDED && (entity2 = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            player.m_213846_((Component)Component.m_237110_((String)"ui.irons_spellbooks.summon_despawn_message", (Object[])new Object[]{((Entity)this).m_5446_()}));
        }
        if (reason != null && reason.m_146965_()) {
            SummonManager.removeSummon(entity);
            SummonManager.stopTrackingExpiration(entity);
        }
    }

    @Deprecated(forRemoval=true)
    default public void onRemovedHelper(Entity entity, RegistryObject<MobEffect> holder) {
        Entity entity2;
        Entity.RemovalReason reason = entity.m_146911_();
        if (reason != null && (entity2 = this.getSummoner()) instanceof ServerPlayer) {
            MobEffectInstance effect;
            ServerPlayer player = (ServerPlayer)entity2;
            if (reason.m_146965_() && (effect = player.m_21124_((MobEffect)holder.get())) != null) {
                MobEffectInstance decrement = new MobEffectInstance((MobEffect)holder.get(), effect.m_19557_(), effect.m_19564_() - 1, false, false, true);
                if (decrement.m_19564_() >= 0) {
                    player.m_21221_().put((MobEffect)holder.get(), decrement);
                    player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), decrement));
                } else {
                    player.m_21195_((MobEffect)holder.get());
                }
            }
        }
        this.onRemovedHelper(entity);
    }
}

