/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.datagen;

import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.core.DBItems;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DBItemModels
extends ItemModelProvider {
    public DBItemModels(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        ItemGenerationHelper helper = new ItemGenerationHelper("decorative_blocks", this);
        for (VanillaWoodTypes wood : VanillaWoodTypes.values()) {
            if (wood != VanillaWoodTypes.BAMBOO) {
                ((ItemModelBuilder)this.getBuilder(wood + "_beam")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + wood + "_beam_y")));
            }
            ((ItemModelBuilder)this.getBuilder(wood + "_palisade")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + wood + "_palisade_inventory")));
            helper.seatModel(wood);
            helper.supportModel(wood);
        }
        helper.blockItem((Block)DBBlocks.ROCKY_DIRT.get());
        helper.simpleItem((ItemLike)DBItems.CHAIN.get());
        helper.simpleItem((ItemLike)DBItems.BRAZIER.get());
        helper.simpleItem((ItemLike)DBItems.SOUL_BRAZIER.get());
    }

    public String m_6055_() {
        return "Decorative Block Item Models";
    }

    public static class ItemGenerationHelper {
        private String modid;
        private ItemModelProvider provider;

        public ItemGenerationHelper(String modid, ItemModelProvider provider) {
            this.modid = modid;
            this.provider = provider;
        }

        private void blockItem(Block block) {
            String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
            ((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(this.provider.modLoc("block/" + name)));
        }

        private void simpleItem(ItemLike item) {
            String name = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_();
            this.generated(name, this.provider.modLoc("item/" + name));
        }

        public void simpleItem(ItemLike item, ResourceLocation texture) {
            String name = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_();
            this.generated(name, texture);
        }

        public void generated(String path, ResourceLocation texture) {
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(path)).parent(this.newModel(this.provider.mcLoc("item/generated")))).texture("layer0", texture);
        }

        public void supportModel(IWoodType wood) {
            String name = wood + "_support";
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(name + "_inventory"))).override().model(this.newModel(wood + "_upside_down_support_inventory")).predicate(SupportItem.OVERRIDE_TAG, 1.0f).end();
        }

        public void seatModel(IWoodType wood) {
            String name = wood + "_seat";
            ((ItemModelBuilder)((ItemModelBuilder)this.provider.getBuilder(name)).parent(this.newModel(name + "_inventory"))).override().model(this.newModel(name + "_post_inventory")).predicate(SeatItem.OVERRIDE_TAG, 1.0f).end();
        }

        public ModelFile newModel(String name) {
            return this.newModel(this.modBlockLoc(name));
        }

        public ModelFile newModel(ResourceLocation location) {
            return new ModelFile.UncheckedModelFile(location);
        }

        public ResourceLocation modBlockLoc(String name) {
            return new ResourceLocation(this.modid, "block/" + name);
        }
    }
}

