/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks.types;

import lilypuree.decorative_blocks.blocks.types.IWoodType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VanillaWoodTypes implements IWoodType
{
    OAK("oak"),
    BIRCH("birch"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283761_;
        }
    }
    ,
    SPRUCE("spruce"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283819_;
        }
    }
    ,
    ACACIA("acacia"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283750_;
        }
    }
    ,
    JUNGLE("jungle"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283762_;
        }
    }
    ,
    DARK_OAK("dark_oak"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283748_;
        }
    }
    ,
    MANGROVE("mangrove"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283913_;
        }
    }
    ,
    CHERRY("cherry"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283765_;
        }
    }
    ,
    BAMBOO("bamboo"){

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283916_;
        }
    }
    ,
    CRIMSON("crimson"){

        @Override
        public boolean isFlammable() {
            return false;
        }

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283820_;
        }
    }
    ,
    WARPED("warped"){

        @Override
        public boolean isFlammable() {
            return false;
        }

        @Override
        public MapColor getMapColor() {
            return MapColor.f_283772_;
        }
    };

    private final String name;

    private VanillaWoodTypes(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String namespace() {
        return "minecraft";
    }

    public String getName() {
        return this.name;
    }

    public static VanillaWoodTypes withName(String name) {
        if (name.equalsIgnoreCase("oak")) {
            return OAK;
        }
        if (name.equalsIgnoreCase("birch")) {
            return BIRCH;
        }
        if (name.equalsIgnoreCase("spruce")) {
            return SPRUCE;
        }
        if (name.equalsIgnoreCase("acacia")) {
            return ACACIA;
        }
        if (name.equalsIgnoreCase("jungle")) {
            return JUNGLE;
        }
        if (name.equalsIgnoreCase("dark")) {
            return DARK_OAK;
        }
        if (name.equalsIgnoreCase("mangrove")) {
            return MANGROVE;
        }
        if (name.equalsIgnoreCase("cherry")) {
            return CHERRY;
        }
        if (name.equalsIgnoreCase("bamboo")) {
            return BAMBOO;
        }
        if (name.equalsIgnoreCase("crimson")) {
            return CRIMSON;
        }
        if (name.equalsIgnoreCase("warped")) {
            return WARPED;
        }
        return OAK;
    }

    public static VanillaWoodTypes fromPath(String path) {
        String[] paths = path.split("_");
        return VanillaWoodTypes.withName(paths[0]);
    }

    @Override
    public Block getLog() {
        switch (this) {
            case OAK: {
                return Blocks.f_49999_;
            }
            case SPRUCE: {
                return Blocks.f_50000_;
            }
            case BIRCH: {
                return Blocks.f_50001_;
            }
            case JUNGLE: {
                return Blocks.f_50002_;
            }
            case DARK_OAK: {
                return Blocks.f_50004_;
            }
            case ACACIA: {
                return Blocks.f_50003_;
            }
            case MANGROVE: {
                return Blocks.f_220832_;
            }
            case CHERRY: {
                return Blocks.f_271170_;
            }
            case BAMBOO: {
                return Blocks.f_256740_;
            }
            case CRIMSON: {
                return Blocks.f_50695_;
            }
            case WARPED: {
                return Blocks.f_50686_;
            }
        }
        return Blocks.f_49999_;
    }

    @Override
    public Block getStrippedLog() {
        switch (this) {
            case OAK: {
                return Blocks.f_50010_;
            }
            case SPRUCE: {
                return Blocks.f_50005_;
            }
            case BIRCH: {
                return Blocks.f_50006_;
            }
            case JUNGLE: {
                return Blocks.f_50007_;
            }
            case DARK_OAK: {
                return Blocks.f_50009_;
            }
            case ACACIA: {
                return Blocks.f_50008_;
            }
            case MANGROVE: {
                return Blocks.f_220835_;
            }
            case CHERRY: {
                return Blocks.f_271326_;
            }
            case BAMBOO: {
                return Blocks.f_256740_;
            }
            case CRIMSON: {
                return Blocks.f_50696_;
            }
            case WARPED: {
                return Blocks.f_50687_;
            }
        }
        return Blocks.f_50010_;
    }

    @Override
    public Block getSlab() {
        switch (this) {
            case OAK: {
                return Blocks.f_50398_;
            }
            case SPRUCE: {
                return Blocks.f_50399_;
            }
            case BIRCH: {
                return Blocks.f_50400_;
            }
            case JUNGLE: {
                return Blocks.f_50401_;
            }
            case DARK_OAK: {
                return Blocks.f_50403_;
            }
            case ACACIA: {
                return Blocks.f_50402_;
            }
            case MANGROVE: {
                return Blocks.f_220851_;
            }
            case CHERRY: {
                return Blocks.f_271301_;
            }
            case BAMBOO: {
                return Blocks.f_244004_;
            }
            case CRIMSON: {
                return Blocks.f_50657_;
            }
            case WARPED: {
                return Blocks.f_50658_;
            }
        }
        return Blocks.f_50398_;
    }

    @Override
    public Block getFence() {
        switch (this) {
            case OAK: {
                return Blocks.f_50132_;
            }
            case SPRUCE: {
                return Blocks.f_50479_;
            }
            case BIRCH: {
                return Blocks.f_50480_;
            }
            case JUNGLE: {
                return Blocks.f_50481_;
            }
            case DARK_OAK: {
                return Blocks.f_50483_;
            }
            case ACACIA: {
                return Blocks.f_50482_;
            }
            case MANGROVE: {
                return Blocks.f_220852_;
            }
            case CHERRY: {
                return Blocks.f_271219_;
            }
            case BAMBOO: {
                return Blocks.f_244641_;
            }
            case CRIMSON: {
                return Blocks.f_50661_;
            }
            case WARPED: {
                return Blocks.f_50662_;
            }
        }
        return Blocks.f_50132_;
    }

    @Override
    public Block getPlanks() {
        switch (this) {
            case OAK: {
                return Blocks.f_50705_;
            }
            case SPRUCE: {
                return Blocks.f_50741_;
            }
            case BIRCH: {
                return Blocks.f_50742_;
            }
            case JUNGLE: {
                return Blocks.f_50743_;
            }
            case DARK_OAK: {
                return Blocks.f_50745_;
            }
            case ACACIA: {
                return Blocks.f_50744_;
            }
            case MANGROVE: {
                return Blocks.f_220865_;
            }
            case CHERRY: {
                return Blocks.f_271304_;
            }
            case BAMBOO: {
                return Blocks.f_244477_;
            }
            case CRIMSON: {
                return Blocks.f_50655_;
            }
            case WARPED: {
                return Blocks.f_50656_;
            }
        }
        return Blocks.f_50705_;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isFlammable() {
        return true;
    }
}

