/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.world.gen.features;

import com.mojang.serialization.Codec;
import com.ninni.twigs.registry.TwigsBlocks;
import com.ninni.twigs.world.FastNoise;
import com.ninni.twigs.world.gen.features.config.NoiseStripConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class NoiseStripFeature
extends Feature<NoiseStripConfig> {
    public NoiseStripFeature(Codec<NoiseStripConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoiseStripConfig> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        int seed = (int)world.m_7328_();
        FastNoise fastNoise = new FastNoise(seed);
        fastNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
        fastNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
        fastNoise.SetFractalOctaves(1);
        fastNoise.SetFrequency(0.004f);
        fastNoise.SetGradientPerturbAmp(0.3f);
        int range = 16;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < range; ++x) {
            for (int z = 0; z < range; ++z) {
                for (int y = 0; y < range; ++y) {
                    BlockState blockState;
                    mutableBlockPos.m_122178_(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    float noise = fastNoise.GetNoise(mutableBlockPos.m_123341_(), mutableBlockPos.m_123342_(), mutableBlockPos.m_123343_());
                    double threshold = 0.97655;
                    if (!((double)noise > threshold) || !(blockState = world.m_8055_((BlockPos)mutableBlockPos)).m_204336_(BlockTags.f_13062_)) continue;
                    for (Direction direction : Direction.values()) {
                        if (!world.m_7433_(mutableBlockPos.m_121945_(direction), DripstoneUtils::m_159666_)) continue;
                        world.m_7731_((BlockPos)mutableBlockPos, ((Block)TwigsBlocks.SILT.get()).m_49966_(), 2);
                    }
                }
            }
        }
        return true;
    }
}

