/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.adorable_eggs.forge.loot;

import com.cerbon.adorable_eggs.loot.LootTablesToModify;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ADELootModifiersForge
extends LootModifier {
    public static final Supplier<Codec<ADELootModifiersForge>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> ADELootModifiersForge.codecStart((RecordCodecBuilder.Instance)instance).and((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.STRING.fieldOf("loot_table").forGetter(m -> m.lootTable)).apply((Applicative)instance, ADELootModifiersForge::new)));
    private final Item item;
    private final String lootTable;

    public ADELootModifiersForge(LootItemCondition[] conditionsIn, Item item, String lootTable) {
        super(conditionsIn);
        this.item = item;
        this.lootTable = lootTable;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext lootContext) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)lootContext)) continue;
            return generatedLoot;
        }
        if (LootItemRandomChanceCondition.m_81927_((float)LootTablesToModify.DROP_CHANCE_MAP.getOrDefault(this.lootTable, Float.valueOf(0.0f)).floatValue()).m_6409_().test((Object)lootContext)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    @NotNull
    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

