/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.api.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createcasing.api.blocks.ApiCogwheelBlock;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ApiCogwheelBlockEntityRenderer
extends KineticBlockEntityRenderer<BracketedKineticBlockEntity> {
    public ApiCogwheelBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BracketedKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        Block block = be.m_58900_().m_60734_();
        if (!(block instanceof ApiCogwheelBlock)) {
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        ApiCogwheelBlock block2 = (ApiCogwheelBlock)block;
        if (!block2.isLargeCog()) {
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        Direction.Axis axis = ApiCogwheelBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ApiCogwheelBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)((ApiCogwheelBlock)be.m_58900_().m_60734_()).getModel(), (BlockState)be.m_58900_(), (Direction)facing), (PoseStack)ms, (VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (int)light);
        float angle = ApiCogwheelBlockEntityRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, axis);
        SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)be.m_58900_(), (Direction)facing);
        ApiCogwheelBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
        shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.m_58899_();
        float offset = ApiCogwheelBlockEntityRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

