/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObjectNonFaceable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Desk
extends FurnitureObjectNonFaceable {
    public static final DirectionProperty FACING_TWO_DIRECTIONAL = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.m_61598_((String)"connection", ConnectionStatus.class, (Enum[])new ConnectionStatus[]{ConnectionStatus.SINGLE, ConnectionStatus.MIDDLE, ConnectionStatus.LEFT, ConnectionStatus.RIGHT});
    protected static final VoxelShape NORTH_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0)});
    protected static final VoxelShape NORTH_MIDDLE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH_RIGHT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape NORTH_LEFT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape EAST_BASE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1), Block.m_49796_((double)13.1, (double)0.0, (double)0.0, (double)15.1, (double)14.0, (double)16.1)});
    protected static final VoxelShape EAST_MIDDLE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST_RIGHT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.1, (double)14.0, (double)0.0, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.m_49796_((double)13.1, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0));
    protected static final VoxelShape EAST_LEFT = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.m_49796_((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1));

    public Desk(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)Direction.NORTH)).m_61124_(CONNECTION, (Comparable)((Object)ConnectionStatus.SINGLE)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        ConnectionStatus connectionStatus = (ConnectionStatus)((Object)state.m_61143_(CONNECTION));
        switch ((Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL)) {
            case NORTH: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return NORTH_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return NORTH_LEFT;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_BASE;
            }
        }
        if (connectionStatus == ConnectionStatus.MIDDLE) {
            return EAST_MIDDLE;
        }
        if (connectionStatus == ConnectionStatus.LEFT) {
            return EAST_LEFT;
        }
        if (connectionStatus == ConnectionStatus.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_BASE;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL);
        Direction rotatedDirection = rot.m_55954_(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)rotatedDirection);
    }

    public BlockState m_6943_(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.m_122424_();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)rotatedDirection);
    }

    private BlockState TableState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = level.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL), north, east, south, west);
        return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        if (facing == Direction.NORTH) {
            if (north && south && !east && !west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && south && !east && !west) {
                return ConnectionStatus.RIGHT;
            }
            if (north && !south && !east && !west) {
                return ConnectionStatus.LEFT;
            }
        }
        if (facing == Direction.EAST) {
            if (!north && !south && east && west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && !south && east && !west) {
                return ConnectionStatus.LEFT;
            }
            if (!north && !south && !east && west) {
                return ConnectionStatus.RIGHT;
            }
        }
        return ConnectionStatus.SINGLE;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        Direction currentFacing = (Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL);
        BlockState defaultState = (BlockState)this.m_49966_().m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)currentFacing);
        level.m_7731_(pos, this.TableState(defaultState, (LevelAccessor)level, pos), 2);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING_TWO_DIRECTIONAL, CONNECTION});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        this.TableState(state, (LevelAccessor)level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)this.TableState(state, level, pos).m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)((Direction)state.m_61143_((Property)FACING_TWO_DIRECTIONAL)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction playerFacing = context.m_8125_();
        return (BlockState)this.TableState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING_TWO_DIRECTIONAL, (Comparable)(switch (playerFacing) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.WEST -> Direction.NORTH;
            default -> Direction.NORTH;
        }));
    }

    public void placeAt(Level level, BlockPos pos, int number) {
        level.m_7731_(pos, this.m_49966_(), number);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        SINGLE("single"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

