/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.network.packets;

import cy.jdkdigital.jearchaeology.JEArchaeology;
import cy.jdkdigital.jearchaeology.jei.BrushRecipeCategory;
import cy.jdkdigital.jearchaeology.jei.SniffRecipeCategory;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.network.NetworkEvent;

public class Messages {

    public static class BrushingDataMessage
    implements RecipeMessage {
        public List<BrushingRecipe> data;

        public BrushingDataMessage(List<BrushingRecipe> data) {
            this.data = data;
        }

        public static void encode(BrushingDataMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.data.size());
            for (BrushingRecipe entry : message.data) {
                buffer.m_130085_(entry.m_6423_());
                ((RecipeSerializer)JEArchaeology.BRUSH.get()).m_6178_(buffer, (Recipe)entry);
            }
        }

        public static BrushingDataMessage decode(FriendlyByteBuf buffer) {
            ArrayList<BrushingRecipe> data = new ArrayList<BrushingRecipe>();
            IntStream.range(0, buffer.readInt()).forEach(i -> data.add((BrushingRecipe)((RecipeSerializer)JEArchaeology.BRUSH.get()).m_8005_(buffer.m_130281_(), buffer)));
            return new BrushingDataMessage(data);
        }

        public static void handle(BrushingDataMessage message, Supplier<NetworkEvent.Context> context) {
            BrushRecipeCategory.setRecipes(message.data);
            context.get().setPacketHandled(true);
        }
    }

    public static class SnifferDataMessage
    implements RecipeMessage {
        public List<SniffRecipe> data;

        public SnifferDataMessage(List<SniffRecipe> data) {
            this.data = data;
        }

        public static void encode(SnifferDataMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.data.size());
            for (SniffRecipe entry : message.data) {
                buffer.m_130085_(entry.m_6423_());
                ((RecipeSerializer)JEArchaeology.SNIFF.get()).m_6178_(buffer, (Recipe)entry);
            }
        }

        public static SnifferDataMessage decode(FriendlyByteBuf buffer) {
            ArrayList<SniffRecipe> data = new ArrayList<SniffRecipe>();
            IntStream.range(0, buffer.readInt()).forEach(i -> data.add((SniffRecipe)((RecipeSerializer)JEArchaeology.SNIFF.get()).m_8005_(buffer.m_130281_(), buffer)));
            return new SnifferDataMessage(data);
        }

        public static void handle(SnifferDataMessage message, Supplier<NetworkEvent.Context> context) {
            SniffRecipeCategory.setRecipes(message.data);
            context.get().setPacketHandled(true);
        }
    }

    public static interface RecipeMessage {
    }
}

