/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MeltingSlot
implements ContainerData {
    private ItemStack stack;
    private final CrucibleBlockEntity be;
    public ProcessingRecipe<?> currentRecipe;
    public int processingTime;
    public int processDuration;
    private static final Object BulkMeltingCacheKey = new Object();

    public MeltingSlot(CrucibleBlockEntity be) {
        this.be = be;
        this.processingTime = 0;
        this.stack = ItemStack.f_41583_;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    private void reset() {
        this.processingTime = -1;
        this.processDuration = -1;
        this.currentRecipe = null;
    }

    private void startRecipe() {
        ProcessingRecipe<?> recipe = this.getMatchingRecipe();
        if (recipe != null) {
            int duration = recipe.getProcessingDuration();
            float speed = Mth.m_14036_((float)((float)this.be.foundry.getCurrentHeat() / (float)FoundryRecipe.getHeatRequirement(recipe)), (float)1.0f, (float)3.0f);
            this.processDuration = this.processingTime = (int)((float)duration / speed);
            this.currentRecipe = recipe;
        }
    }

    public void setStack(ItemStack newStack) {
        if (this.stack.m_41619_()) {
            this.reset();
        }
        this.stack = newStack;
        this.startRecipe();
        this.be.notifyUpdate();
    }

    public boolean canMelt() {
        if (this.processingTime > 0 && this.currentRecipe != null) {
            return FoundryRecipe.isEnoughHeated(this.be, this.currentRecipe);
        }
        this.startRecipe();
        return false;
    }

    public void heatItem() {
        --this.processingTime;
        if (this.processingTime <= 0) {
            this.tryMeltItem();
        }
        this.be.notifyUpdate();
    }

    public void coolItem() {
        if (this.processingTime < this.processDuration) {
            ++this.processingTime;
            this.be.notifyUpdate();
        }
    }

    public void tryMeltItem() {
        if (this.currentRecipe == null) {
            return;
        }
        IFluidHandler fluidHandler = (IFluidHandler)this.be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        for (FluidStack output : this.currentRecipe.getFluidResults()) {
            if (fluidHandler.fill(output.copy(), IFluidHandler.FluidAction.SIMULATE) >= output.getAmount()) {
                fluidHandler.fill(output.copy(), IFluidHandler.FluidAction.EXECUTE);
                this.setStack(ItemStack.f_41583_);
            }
            this.reset();
        }
    }

    private ProcessingRecipe<?> getMatchingRecipe() {
        Level level = this.be.m_58904_();
        if (level == null) {
            return null;
        }
        Predicate type = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{CMRecipeTypes.BULK_MELTING.getType(), CMRecipeTypes.MELTING.getType()});
        List<Recipe> recipes = RecipeFinder.get((Object)BulkMeltingCacheKey, (Level)level, (Predicate)type).stream().filter(r -> FoundryRecipe.matchSpecific(this.getStack(), r)).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).toList();
        if (!recipes.isEmpty()) {
            return (ProcessingRecipe)recipes.get(0);
        }
        return null;
    }

    public int m_6413_(int pIndex) {
        return 0;
    }

    public void m_8050_(int pIndex, int pValue) {
    }

    public int m_6499_() {
        return 0;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
        this.processingTime = nbt.m_128451_("processingTime");
        this.processDuration = nbt.m_128451_("processDuration");
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        nbt.m_128405_("processingTime", this.processingTime);
        nbt.m_128405_("processDuration", this.processDuration);
        return nbt;
    }
}

