/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.WindchestBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.block.pipes.generic.GenericSoundInstance;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;

public class GenericPipeBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public LerpedFloat animation = LerpedFloat.angular();
    protected int pitch;
    protected float steamJetOffset = 0.125f;
    protected GenericPipeBlock pipeBlock;
    @OnlyIn(value=Dist.CLIENT)
    protected GenericSoundInstance soundInstance;

    public GenericPipeBlockEntity(BlockPos pos, BlockState blockState, RegistryObject<BlockEntityType> blockEntity) {
        super((BlockEntityType)blockEntity.get(), pos, blockState);
        this.pipeBlock = (GenericPipeBlock)blockState.m_60734_();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("Pitch", this.pitch);
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        this.pitch = tag.m_128451_("Pitch");
        super.read(tag, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = CreateLang.translateDirect((String)"generic.notes", (Object[])new Object[0]).getString().split(";");
        CreateLang.translate((String)"generic.pitch", (Object[])new Object[]{pitches[this.pitch % pitches.length]}).forGoggles(tooltip);
        return true;
    }

    protected boolean isPowered() {
        return this.m_58900_().m_61145_((Property)GenericPipeBlock.POWERED).orElse(false);
    }

    protected Generic.WhistleSize getOctave() {
        return this.m_58900_().m_61145_(GenericPipeBlock.SIZE).orElse(Generic.WhistleSize.MEDIUM);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_()) {
            if (this.isPowered()) {
                this.award(AllAdvancements.STEAM_WHISTLE);
            }
            return;
        }
        FluidTankBlockEntity tank = this.getTank();
        BlockState state = this.m_58900_();
        BlockPos attachedPos = this.m_58899_().m_121945_(GenericPipeBlock.getAttachedDirection(state));
        BlockState attachedState = this.f_58857_.m_8055_(attachedPos);
        boolean isActive = false;
        Block block = attachedState.m_60734_();
        if (block instanceof WindchestBlock) {
            WindchestBlock windchest = (WindchestBlock)block;
            isActive = windchest.isMasterActive(this.f_58857_, (Direction)attachedState.m_61143_((Property)GenericPipeBlock.FACING), attachedPos);
        }
        boolean powered = this.isPowered() ? tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual() || isActive : false;
        this.animation.chase(powered ? 1.0 : 0.0, powered ? 0.5 : (double)0.4f, powered ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAudio(this.getOctave(), powered));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(Generic.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.f_58857_.m_46467_() % 8L == 0L;
        Vec3 eyePosition = Minecraft.m_91087_().f_91075_.m_146892_();
        float maxVolume = (float)Mth.m_14008_((double)((64.0 - eyePosition.m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new GenericSoundInstance(size, this.f_58858_, (SoundEvent)com.finchy.pipeorgans.init.AllSoundEvents.TROMPETTE_DEEP.get());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.f_58857_, (Vec3i)this.f_58858_, maxVolume * 0.1f, f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        this.createSteamJet(size);
    }

    public void createSteamJet(Generic.WhistleSize size) {
        Direction facing = this.m_58900_().m_61145_((Property)GenericPipeBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle((Direction)facing);
        Vec3 sizeOffset = VecHelper.rotate((Vec3)new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 1.0, 0.75), (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 v = offset.m_82490_((double)0.45f).m_82549_(sizeOffset).m_82549_(Vec3.m_82512_((Vec3i)this.f_58858_));
        Vec3 m = offset.m_82546_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.75));
        this.f_58857_.m_7106_((ParticleOptions)new SteamJetParticleData(1.0f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
    }

    public void updatePitch() {
        BlockState blockState;
        int newPitch;
        BlockPos currentPos = this.f_58858_.m_7494_();
        for (newPitch = 0; newPitch <= 12 && (blockState = this.f_58857_.m_8055_(currentPos)).m_60734_() instanceof GenericExtensionBlock; newPitch += this.pipeBlock.extensionsPerBlock) {
            if (blockState.m_61143_(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.SINGLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.25);
                break;
            }
            if (blockState.m_61143_(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.DOUBLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.5);
                break;
            }
            if (blockState.m_61143_(GenericExtensionBlock.SHAPE) == Generic.QuadrupleExtensionShape.TRIPLE) {
                newPitch += (int)((double)this.pipeBlock.extensionsPerBlock * 0.75);
                break;
            }
            currentPos = currentPos.m_7494_();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing = GenericPipeBlock.getAttachedDirection(this.m_58900_())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

