/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block.pipes.generic;

import com.finchy.pipeorgans.block.Generic;
import com.finchy.pipeorgans.block.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class GenericExtensionBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<Generic.QuadrupleExtensionShape> SHAPE = EnumProperty.m_61587_((String)"shape", Generic.QuadrupleExtensionShape.class);
    public static final EnumProperty<Generic.WhistleSize> SIZE = GenericPipeBlock.SIZE;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public RegistryObject<? extends GenericPipeBlock> baseBlock;

    public GenericExtensionBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.DOUBLE))).m_61124_(SIZE, (Comparable)((Object)Generic.WhistleSize.MEDIUM))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.getGenericExtensionShape((Generic.QuadrupleExtensionShape)((Object)pState.m_61143_(SHAPE)), (Generic.WhistleSize)((Object)pState.m_61143_(SIZE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{SHAPE, SIZE, FACING}));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        return below.m_60713_((Block)this) && below.m_61143_(SHAPE) == Generic.QuadrupleExtensionShape.QUAD_CONNECTED || below.m_60734_() instanceof GenericPipeBlock;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.m_122434_() != Direction.Axis.Y) {
            return pState;
        }
        if (pFacing == Direction.UP) {
            boolean connected = pState.m_61143_(SHAPE) == Generic.QuadrupleExtensionShape.QUAD_CONNECTED;
            boolean shouldConnect = pLevel.m_8055_(pCurrentPos.m_7494_()).m_60713_((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.m_61124_(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.QUAD_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.m_61124_(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.QUAD));
            }
            return pState;
        }
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)pState.m_61124_(SIZE, (Comparable)((Object)((Generic.WhistleSize)((Object)pLevel.m_8055_(pCurrentPos.m_7495_()).m_61143_(SIZE)))));
    }

    public static BlockPos findRoot(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockState;
        BlockPos currentPos = pPos.m_7495_();
        while ((blockState = pLevel.m_8055_(currentPos)).m_60734_() instanceof GenericExtensionBlock) {
            currentPos = currentPos.m_7495_();
        }
        return currentPos;
    }

    protected UseOnContext relocateContext(UseOnContext context, BlockPos target) {
        return new UseOnContext(context.m_43723_(), context.m_43724_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), target, context.m_43721_()));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (heldItem.m_41720_() != ((GenericPipeBlock)((Object)this.baseBlock.get())).m_5456_()) {
            return InteractionResult.PASS;
        }
        BlockPos rootFound = GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos);
        BlockState blockState = pLevel.m_8055_(rootFound);
        Block block = blockState.m_60734_();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.m_6227_(blockState, pLevel, rootFound, pPlayer, pHand, new BlockHitResult(pHit.m_82450_(), pHit.m_82434_(), rootFound, pHit.m_82436_()));
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (context.m_43720_().f_82480_ < (double)((float)context.m_8083_().m_123342_() + 0.5f) || state.m_61143_(SHAPE) == Generic.QuadrupleExtensionShape.DOUBLE) {
            return super.onSneakWrenched(state, context);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Generic.QuadrupleExtensionShape.DOUBLE)), 3);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult sneakWrenchedRemove(BlockState state, UseOnContext context) {
        return super.onSneakWrenched(state, context);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos findRoot;
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(findRoot = GenericExtensionBlock.findRoot((LevelAccessor)level, context.m_8083_()));
        Block block = blockState.m_60734_();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock pipe = (GenericPipeBlock)block;
            return pipe.onWrenched(blockState, this.relocateContext(context, findRoot));
        }
        return super.onWrenched(state, context);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.m_60734_() != this || pOldState.m_61143_(SHAPE) != pState.m_61143_(SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pOldState.m_60734_() != this || pOldState.m_61143_(SHAPE) != pState.m_61143_(SHAPE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, GenericExtensionBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.baseBlock.get());
    }
}

