/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block;

import com.finchy.pipeorgans.block.WindchestMasterBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindchestBlock
extends Block
implements IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public WindchestBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public boolean isMasterWindy(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        if (masterPos != pos) {
            return (Boolean)level.m_8055_(masterPos).m_61143_((Property)WindchestMasterBlock.WINDY);
        }
        return false;
    }

    public boolean isMasterPowered(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        if (masterPos != pos) {
            return (Boolean)level.m_8055_(masterPos).m_61143_((Property)POWERED);
        }
        return false;
    }

    public boolean isMasterActive(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        BlockState masterState = level.m_8055_(masterPos);
        if (masterPos != pos) {
            return (Boolean)masterState.m_61143_((Property)POWERED) != false && (Boolean)masterState.m_61143_((Property)WindchestMasterBlock.WINDY) != false;
        }
        return false;
    }

    public BlockPos getMasterPos(Level level, Direction facing, BlockPos pos) {
        BlockPos currentPos = pos;
        for (int i = 0; i <= 12; ++i) {
            BlockState currentBlock = level.m_8055_(currentPos = currentPos.m_121945_(facing));
            if (currentBlock.m_60734_() instanceof WindchestMasterBlock && currentBlock.m_61143_((Property)FACING) == facing.m_122424_()) {
                return currentPos;
            }
            if (!(currentBlock.m_60734_() instanceof WindchestBlock) || currentBlock.m_61143_((Property)FACING) != facing) break;
        }
        return pos;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Direction facing = pContext.m_8125_();
        Direction direction = pContext.m_43723_().m_6144_() ? facing.m_122424_() : facing;
        return (BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(pContext)).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.isMasterPowered(level, direction, clickedPos)));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if (pPos.m_121945_(facing).equals((Object)pNeighborPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.isMasterPowered(pLevel, facing, pPos))), 3);
        }
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

