/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeWrapper
extends UpgradeWrapperBase<JukeboxUpgradeWrapper, JukeboxUpgradeItem>
implements ITickableUpgrade {
    private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
    private final ItemStackHandler discInventory;
    private long lastKeepAliveSendTime = 0L;
    private boolean isPlaying;
    private final LinkedList<Integer> playlist = new LinkedList();
    private final LinkedList<Integer> history = new LinkedList();
    private final Set<Integer> discsRemoved = new HashSet<Integer>();
    private final Set<Integer> discsAdded = new HashSet<Integer>();
    @Nullable
    private Entity entityPlaying = null;
    @Nullable
    private Level levelPlaying = null;
    @Nullable
    private BlockPos posPlaying = null;
    private final Runnable onFinishedCallback = this::onDiscFinished;

    protected JukeboxUpgradeWrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.discInventory = new ItemStackHandler(((JukeboxUpgradeItem)this.upgradeItem).getNumberOfSlots()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                upgrade.m_41700_("discInventory", (Tag)this.serializeNBT());
                JukeboxUpgradeWrapper.this.save();
                if (this.getStackInSlot(slot).m_41619_()) {
                    JukeboxUpgradeWrapper.this.discsRemoved.add(slot);
                    JukeboxUpgradeWrapper.this.discsAdded.remove(slot);
                } else if (!JukeboxUpgradeWrapper.this.playlist.contains(slot)) {
                    JukeboxUpgradeWrapper.this.discsAdded.add(slot);
                    JukeboxUpgradeWrapper.this.discsRemoved.remove(slot);
                }
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof RecordItem;
            }

            public void setSize(int size) {
                if (size < ((JukeboxUpgradeItem)JukeboxUpgradeWrapper.this.upgradeItem).getNumberOfSlots()) {
                    size = ((JukeboxUpgradeItem)JukeboxUpgradeWrapper.this.upgradeItem).getNumberOfSlots();
                }
                super.setSize(size);
            }
        };
        NBTHelper.getCompound(upgrade, "discInventory").ifPresent(arg_0 -> ((ItemStackHandler)this.discInventory).deserializeNBT(arg_0));
        this.isPlaying = NBTHelper.getBoolean(upgrade, "isPlaying").orElse(false);
    }

    public boolean isShuffleEnabled() {
        return NBTHelper.getBoolean(this.upgrade, "shuffle").orElse(false);
    }

    public void setShuffleEnabled(boolean shuffleEnabled) {
        NBTHelper.setBoolean(this.upgrade, "shuffle", shuffleEnabled);
        this.save();
        this.initPlaylist(true);
    }

    public RepeatMode getRepeatMode() {
        return NBTHelper.getEnumConstant(this.upgrade, "repeatMode", RepeatMode::fromName).orElse(RepeatMode.NO);
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        NBTHelper.setEnumConstant(this.upgrade, "repeatMode", repeatMode);
        this.save();
    }

    public ItemStack getDisc() {
        return this.getDiscSlotActive() > -1 ? this.discInventory.getStackInSlot(this.getDiscSlotActive()) : ItemStack.f_41583_;
    }

    public int getDiscSlotActive() {
        return NBTHelper.getInt(this.upgrade, "discSlotActive").orElse(-1);
    }

    private void setDiscSlotActive(int discSlotActive) {
        NBTHelper.setInteger(this.upgrade, "discSlotActive", discSlotActive);
        this.save();
    }

    public void play(Level level, BlockPos pos) {
        if (this.isPlaying) {
            return;
        }
        this.levelPlaying = level;
        this.posPlaying = pos;
        this.playNext();
    }

    public void play(Entity entity) {
        if (this.isPlaying) {
            return;
        }
        this.entityPlaying = entity;
        this.playNext();
    }

    private void playDisc() {
        ServerLevel serverLevel;
        Level level;
        block5: {
            block4: {
                Level level2 = level = this.entityPlaying != null ? this.entityPlaying.m_9236_() : this.levelPlaying;
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (this.posPlaying != null || this.entityPlaying != null) break block5;
            }
            return;
        }
        if (this.getDisc().m_41619_()) {
            return;
        }
        this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> {
            if (this.entityPlaying != null) {
                ServerStorageSoundHandler.startPlayingDisc(serverLevel, this.entityPlaying.m_20182_(), storageUuid, this.entityPlaying.m_19879_(), Item.m_41393_((Item)this.getDisc().m_41720_()), this.onFinishedCallback);
            } else {
                ServerStorageSoundHandler.startPlayingDisc(serverLevel, this.posPlaying, storageUuid, Item.m_41393_((Item)this.getDisc().m_41720_()), this.onFinishedCallback);
            }
            Item patt4749$temp = this.getDisc().m_41720_();
            if (patt4749$temp instanceof RecordItem) {
                RecordItem recordItem = (RecordItem)patt4749$temp;
                int lengthInTicks = recordItem.m_43036_();
                NBTHelper.setLong(this.upgrade, "discFinishTime", level.m_46467_() + (long)lengthInTicks);
                NBTHelper.setLong(this.upgrade, "discLength", lengthInTicks);
            }
        });
        this.setIsPlaying(true);
    }

    private void onDiscFinished() {
        if (this.getRepeatMode() == RepeatMode.ONE) {
            this.playDisc();
        } else if (this.getRepeatMode() == RepeatMode.ALL) {
            this.playNext();
        } else {
            this.playNext(false);
        }
    }

    private void setIsPlaying(boolean playing) {
        this.isPlaying = playing;
        NBTHelper.setBoolean(this.upgrade, "isPlaying", playing);
        if (this.isPlaying) {
            this.storageWrapper.getRenderInfo().setUpgradeRenderData(JukeboxUpgradeRenderData.TYPE, new JukeboxUpgradeRenderData(true));
        } else {
            this.removeRenderData();
            this.setDiscSlotActive(-1);
        }
        this.save();
    }

    private void removeRenderData() {
        this.storageWrapper.getRenderInfo().removeUpgradeRenderData(JukeboxUpgradeRenderData.TYPE);
    }

    public void stop(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc(serverLevel, entity.m_20182_(), storageUuid));
        this.setIsPlaying(false);
        NBTHelper.removeTag(this.upgrade, "discFinishTime");
        NBTHelper.removeTag(this.upgrade, "discLength");
        this.setDiscSlotActive(-1);
        this.playlist.clear();
        this.history.clear();
    }

    public IItemHandler getDiscInventory() {
        return this.discInventory;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            if (!this.discsRemoved.isEmpty()) {
                this.discsRemoved.forEach(index -> {
                    this.playlist.remove(index);
                    this.history.remove(index);
                });
                this.discsRemoved.clear();
            }
            if (!this.discsAdded.isEmpty()) {
                this.playlist.addAll(this.discsAdded);
                this.discsAdded.clear();
            }
        }
        if (this.isPlaying && this.lastKeepAliveSendTime < level.m_46467_() - 5L) {
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, level, Vec3.m_82512_((Vec3i)pos), () -> this.setIsPlaying(false)));
            this.lastKeepAliveSendTime = level.m_46467_();
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void onBeforeRemoved() {
        this.removeRenderData();
    }

    public void next() {
        if (!this.isPlaying) {
            return;
        }
        this.playNext();
    }

    public void playNext() {
        this.playNext(true);
    }

    public void playNext(boolean startOverIfAtTheEnd) {
        Integer discIndex;
        if (this.playlist.isEmpty() && startOverIfAtTheEnd) {
            this.initPlaylist(false);
        }
        if (this.playlist.isEmpty()) {
            return;
        }
        if (this.getDiscSlotActive() != -1) {
            this.history.add(this.getDiscSlotActive());
            if (this.history.size() > this.discInventory.getSlots()) {
                this.history.poll();
            }
        }
        if ((discIndex = this.playlist.poll()) == null) {
            return;
        }
        this.setDiscSlotActive(discIndex);
        this.playDisc();
    }

    private void initPlaylist(boolean excludeActive) {
        this.playlist.clear();
        for (int i = 0; i < this.discInventory.getSlots(); ++i) {
            if (this.discInventory.getStackInSlot(i).m_41619_() || excludeActive && this.isPlaying && i == this.getDiscSlotActive()) continue;
            this.playlist.add(i);
        }
        if (this.isShuffleEnabled()) {
            Collections.shuffle(this.playlist);
        }
    }

    public void previous() {
        if (!this.isPlaying) {
            return;
        }
        this.playPrevious();
    }

    public void playPrevious() {
        if (this.history.isEmpty()) {
            return;
        }
        this.playlist.addFirst(this.getDiscSlotActive());
        Integer discIndex = this.history.pollLast();
        if (discIndex == null) {
            return;
        }
        this.setDiscSlotActive(discIndex);
        this.playDisc();
    }

    public long getDiscFinishTime() {
        return NBTHelper.getLong(this.upgrade, "discFinishTime").orElse(0L);
    }

    public int getDiscLength() {
        return NBTHelper.getInt(this.upgrade, "discLength").orElse(0);
    }
}

