/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.ender_pack;

import forge.com.cursee.ender_pack.EnderPackClient;
import forge.com.cursee.ender_pack.client.block.entity.renderer.EnderPackBlockEntityRenderer;
import forge.com.cursee.ender_pack.client.layer.EnderPackLayer;
import forge.com.cursee.ender_pack.client.model.EnderPackModel;
import forge.com.cursee.ender_pack.core.ClientConfigForge;
import forge.com.cursee.ender_pack.core.network.ModMessagesForge;
import forge.com.cursee.ender_pack.core.network.input.OpenEnderPackKeyForge;
import forge.com.cursee.ender_pack.core.network.packet.ForgeOpenEnderPackC2SPacket;
import forge.com.cursee.ender_pack.core.registry.ModBlockEntities;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class EnderPackClientForge {
    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }

    @Mod.EventBusSubscriber(modid="ender_pack", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (OpenEnderPackKeyForge.ENDER_PACK_KEY_MAPPING.m_90859_()) {
                ModMessagesForge.sendToServer(new ForgeOpenEnderPackC2SPacket());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="ender_pack", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModClientBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                EnderPackClient.init();
                ClientConfigForge.onLoad();
            });
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(OpenEnderPackKeyForge.ENDER_PACK_KEY_MAPPING);
        }

        @SubscribeEvent
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.ENDER_PACK, EnderPackBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterLayerDefinitionsForEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(EnderPackClient.ENDER_PACK_PLAYER_MODEL_LAYER_LOCATION, EnderPackModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void onAddLayersForEntityRenderers(EntityRenderersEvent.AddLayers event) {
            EnderPackClientForge.addLayerToPlayerSkin(event, "default", EnderPackLayer::new);
            EnderPackClientForge.addLayerToPlayerSkin(event, "slim", EnderPackLayer::new);
        }
    }
}

