/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.ender_pack.core.item.type;

import common.com.cursee.ender_pack.core.ServerConfiguredValues;
import common.com.cursee.ender_pack.core.block.type.EnderPackBlock;
import common.com.cursee.ender_pack.core.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class EnderPackEquipableBlockItem
extends BlockItem
implements Equipable {
    public EnderPackEquipableBlockItem() {
        super(ModBlocks.ENDER_PACK, new Item.Properties().stacksTo(1));
    }

    public EquipmentSlot getEquipmentSlot() {
        return ServerConfiguredValues.EXTRA_SLOT_ONLY ? null : EquipmentSlot.CHEST;
    }

    @NotNull
    public SoundEvent getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_LEATHER;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerx) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderPack")));
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        InteractionResult SIDED_SUCCESS = InteractionResult.sidedSuccess((boolean)level.isClientSide());
        Player player = context.getPlayer();
        if (player == null) {
            return SIDED_SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerX) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderPack")));
            return SIDED_SUCCESS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockPos relativePos = clickedPos.relative(context.getClickedFace());
        if (!level.isEmptyBlock(relativePos)) {
            return SIDED_SUCCESS;
        }
        if (level.setBlockAndUpdate(relativePos, (BlockState)ModBlocks.ENDER_PACK.defaultBlockState().setValue((Property)EnderPackBlock.FACING, (Comparable)player.getDirection().getOpposite()))) {
            player.playSound(SoundEvents.ENDER_CHEST_CLOSE);
            level.gameEvent((Entity)player, GameEvent.BLOCK_PLACE, relativePos);
            context.getItemInHand().shrink(1);
        }
        return SIDED_SUCCESS;
    }
}

