/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.network;

import com.tatnux.crafter.jei.PacketSendRecipe;
import com.tatnux.crafter.modules.crafter.data.CraftMode;
import com.tatnux.crafter.modules.crafter.packet.CrafterPacket;
import com.tatnux.crafter.modules.crafter.packet.SelectCraftModePacket;
import com.tatnux.crafter.modules.crafter.packet.SelectRecipePacket;
import com.tatnux.crafter.modules.crafter.packet.SetKeepMode;
import com.tatnux.crafter.modules.crafter.packet.UpdateGhostItemsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "2";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("smartcrafter", "main"), () -> "2", "2"::equals, "2"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, PacketSendRecipe.class, PacketSendRecipe::write, PacketSendRecipe::create, CrafterPacket::handle);
        INSTANCE.registerMessage(1, SelectRecipePacket.class, SelectRecipePacket::write, SelectRecipePacket::create, CrafterPacket::handle);
        INSTANCE.registerMessage(2, SelectCraftModePacket.class, SelectCraftModePacket::write, SelectCraftModePacket::create, CrafterPacket::handle);
        INSTANCE.registerMessage(3, SetKeepMode.class, SetKeepMode::write, SetKeepMode::create, CrafterPacket::handle);
        INSTANCE.registerMessage(4, UpdateGhostItemsPacket.class, UpdateGhostItemsPacket::write, UpdateGhostItemsPacket::create, CrafterPacket::handle);
    }

    public static void sendRecipeToServer(PacketSendRecipe packet) {
        INSTANCE.sendToServer((Object)packet);
    }

    public static void resetRecipe(byte slot) {
        INSTANCE.sendToServer((Object)new SelectRecipePacket(slot, true));
    }

    public static void selectSlot(byte slot) {
        INSTANCE.sendToServer((Object)new SelectRecipePacket(slot, false));
    }

    public static void selectCraftMode(CraftMode mode) {
        INSTANCE.sendToServer((Object)new SelectCraftModePacket(mode));
    }

    public static void setKeepMode(boolean keepMode) {
        INSTANCE.sendToServer((Object)new SetKeepMode(keepMode));
    }

    public static void updateGhostItems(boolean reset) {
        INSTANCE.sendToServer((Object)new UpdateGhostItemsPacket(reset));
    }
}

