/*
 * Decompiled with CFR 0.152.
 */
package com.tatnux.crafter.modules.crafter.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.tatnux.crafter.lib.gui.CrafterIconButton;
import com.tatnux.crafter.lib.gui.GuiTexture;
import com.tatnux.crafter.lib.gui.WidgetBox;
import com.tatnux.crafter.modules.crafter.SmartCrafterModule;
import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterBlockEntity;
import com.tatnux.crafter.modules.crafter.blocks.SmartCrafterMenu;
import com.tatnux.crafter.modules.crafter.client.widget.RecipeList;
import com.tatnux.crafter.modules.crafter.data.CraftMode;
import com.tatnux.crafter.modules.crafter.data.CrafterRecipe;
import com.tatnux.crafter.modules.crafter.data.GhostSlots;
import com.tatnux.crafter.modules.network.NetworkHandler;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.awt.Color;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class SmartCrafterScreen
extends AbstractSimiContainerScreen<SmartCrafterMenu> {
    public static final int BOX_COLOR = new Color(50, 100, 181).getRGB();
    protected static final GuiTexture BG = GuiTexture.CRAFTER;
    protected static final AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;
    private float lastRotate = 0.0f;

    public SmartCrafterScreen(SmartCrafterMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void m_7856_() {
        this.setWindowSize(30 + SmartCrafterScreen.BG.width, SmartCrafterScreen.BG.height + PLAYER.getHeight() - 24);
        this.setWindowOffset(-11, 0);
        super.m_7856_();
        int yFooter = this.f_97736_ + SmartCrafterScreen.BG.height - 47;
        this.m_142416_(new IconButton(this.f_97735_ + 30 + SmartCrafterScreen.BG.width - 33, yFooter, (ScreenElement)AllIcons.I_CONFIRM).withCallback(() -> this.f_96541_.f_91074_.m_6915_()));
        AbstractSimiWidget resetButton = new CrafterIconButton(this.f_97735_ + 185, this.f_97736_ + 56, (ScreenElement)AllIcons.I_DISABLE).withTooltip((Component)Component.m_237113_((String)"Reset the recipe")).tooltipWhenDisabled(false).withDisabled(((SmartCrafterMenu)this.f_97732_)::isCraftingEmpty).withCallback(() -> NetworkHandler.resetRecipe(((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).selectedRecipeIndex));
        this.m_142416_(resetButton);
        this.m_142416_(new WidgetBox((AbstractWidget)resetButton, BOX_COLOR));
        int buttonsX = this.f_97735_ + 40;
        AbstractSimiWidget extButton = new CrafterIconButton(buttonsX, yFooter, (ScreenElement)AllIcons.I_PRIORITY_VERY_LOW).withDisabled(() -> ((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).getSelectedRecipe().getCraftMode() == CraftMode.EXT).withTooltip((Component)Component.m_237113_((String)"Ext")).withDescription(new Component[]{Component.m_237113_((String)"All items output will go in the result slots.")}).withCallback(() -> this.updateCraftMode(CraftMode.EXT));
        AbstractSimiWidget extCButton = new CrafterIconButton(buttonsX + 18, yFooter, (ScreenElement)AllIcons.I_PRIORITY_LOW).withDisabled(() -> ((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).getSelectedRecipe().getCraftMode() == CraftMode.EXTC).withTooltip((Component)Component.m_237113_((String)"Secondary Int")).withDescription(new Component[]{Component.m_237113_((String)"The primary result will go in the result slots"), Component.m_237113_((String)"and the secondary item in the ingredients slots.")}).withCallback(() -> this.updateCraftMode(CraftMode.EXTC));
        AbstractSimiWidget intButton = new CrafterIconButton(buttonsX + 18 + 18, yFooter, (ScreenElement)AllIcons.I_ROTATE_CCW).withDisabled(() -> ((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).getSelectedRecipe().getCraftMode() == CraftMode.INT).withTooltip((Component)Component.m_237113_((String)"Int")).withDescription(new Component[]{Component.m_237113_((String)"All items output will go back in the ingredients slots.")}).withCallback(() -> this.updateCraftMode(CraftMode.INT));
        int keepGap = 72;
        AbstractSimiWidget keepButton = new CrafterIconButton(buttonsX + keepGap, yFooter, (ScreenElement)AllIcons.I_WHITELIST_OR).withDisabled(() -> ((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).keepMode).withTooltip((Component)Component.m_237113_((String)"Keep Mode")).withDescription(new Component[]{Component.m_237113_((String)"1 item will remain in each ingredients slots.")}).withCallback(() -> this.updateKeepMode(true));
        AbstractSimiWidget dontKeepButton = new CrafterIconButton(buttonsX + keepGap + 18, yFooter, (ScreenElement)AllIcons.I_WHITELIST_NOT).withDisabled(() -> !((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).keepMode).withTooltip((Component)Component.m_237113_((String)"Out Mode")).withDescription(new Component[]{Component.m_237113_((String)"No item is kept in the ingredients slots.")}).withCallback(() -> this.updateKeepMode(false));
        int ghostGap = 126;
        AbstractSimiWidget ghostSaveButton = new CrafterIconButton(buttonsX + ghostGap, yFooter, (ScreenElement)AllIcons.I_CONFIG_SAVE).withTooltip((Component)Component.m_237113_((String)"Remember Items")).withCallback(() -> NetworkHandler.updateGhostItems(false));
        AbstractSimiWidget ghostForgetButton = new CrafterIconButton(buttonsX + ghostGap + 18 + 4, yFooter, (ScreenElement)AllIcons.I_TRASH).withDisabled(() -> ((SmartCrafterBlockEntity)((Object)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder))).ghostSlots.isEmpty()).withTooltip((Component)Component.m_237113_((String)"Forget Items")).withCallback(() -> NetworkHandler.updateGhostItems(true));
        this.addRenderableWidgets((GuiEventListener[])new AbstractSimiWidget[]{extButton, extCButton, intButton, keepButton, dontKeepButton, ghostSaveButton, ghostForgetButton});
        RecipeList recipeList = new RecipeList(this, this.f_97735_ + 38, this.f_97736_ - 2, 110, 75);
        this.m_142416_(recipeList);
        recipeList.init();
    }

    @NotNull
    public <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T pWidget) {
        return (T)super.m_142416_(pWidget);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x = this.f_97735_ + this.f_97726_ - SmartCrafterScreen.BG.width;
        int y = this.f_97736_ - 23;
        BG.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + 15, y + 4, Color.decode("#BEBEBE").getRGB(), false);
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.f_97736_ + this.f_97727_ - PLAYER.getHeight();
        this.renderPlayerInventory(graphics, invX, invY);
        this.renderCrafter(graphics, x + SmartCrafterScreen.BG.width + 55, y + SmartCrafterScreen.BG.height + 15, partialTicks);
        this.drawGhostSlots(graphics);
    }

    private void renderCrafter(GuiGraphics graphics, int x, int y, float partialTicks) {
        PoseStack ms = graphics.m_280168_();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).pushPose().translate((float)x, (float)y, 100.0f).scale(50.0f)).rotateX(-22.0f)).rotateY(-202.0f);
        GuiGameElement.of((BlockState)SmartCrafterModule.SMART_CRAFTER.getDefaultState()).render(graphics);
        this.lastRotate %= 360.0f;
        TransformStack.of((PoseStack)ms).pushPose();
        GuiGameElement.of((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL).rotateBlock(90.0, Math.abs(((SmartCrafterBlockEntity)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder)).getSpeed()) > 0.0f ? (double)(this.lastRotate += ((SmartCrafterBlockEntity)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder)).getSpeed() / 24.0f) : 22.0, 0.0).render(graphics);
        ms.m_85849_();
        ms.m_85849_();
    }

    private void drawGhostSlots(GuiGraphics graphics) {
        Lighting.m_84931_();
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 100.0f);
        GhostSlots ghostSlots = ((SmartCrafterBlockEntity)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder)).ghostSlots;
        GlStateManager._enableDepthTest();
        GlStateManager._disableBlend();
        for (GhostSlots.GhostSlotEntry entry : ghostSlots.getEntries()) {
            ItemStack item = entry.getItem();
            if (item.m_41619_()) continue;
            for (Byte slotIndex : entry.getSlots()) {
                Slot slot = ((SmartCrafterMenu)this.f_97732_).m_38853_(slotIndex.byteValue());
                if (slot.m_6657_()) continue;
                SmartCrafterScreen.renderGhostItem(graphics, item, slot);
            }
        }
        matrixStack.m_85849_();
    }

    private static void renderGhostItem(GuiGraphics graphics, ItemStack stack, Slot slot) {
        SmartCrafterScreen.renderAndDecorateItem(graphics, stack, slot.f_40220_, slot.f_40221_);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AllGuiTextures.PLAYER_INVENTORY.location);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        SmartCrafterScreen.drawTexturedModalRect(graphics.m_280168_(), slot.f_40220_, slot.f_40221_, 8, 18, 16, 16);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderAndDecorateItem(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280256_(stack, x, y, x * y * 31);
        graphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, x, y, null);
    }

    public static void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * f, (float)(v + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * f, (float)v * f1).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * f, (float)v * f1).m_5752_();
        tessellator.m_85914_();
    }

    private void updateCraftMode(CraftMode mode) {
        CrafterRecipe selectedRecipe = ((SmartCrafterBlockEntity)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder)).getSelectedRecipe();
        if (selectedRecipe.getCraftMode() != mode) {
            NetworkHandler.selectCraftMode(mode);
        }
    }

    private void updateKeepMode(boolean keepMode) {
        if (((SmartCrafterBlockEntity)((Object)((SmartCrafterMenu)this.f_97732_).contentHolder)).keepMode != keepMode) {
            NetworkHandler.setKeepMode(keepMode);
        }
    }
}

