/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.utils;

import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.utils.PrivateAccess;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class ManualRecipeRef {
    private final ItemStack output;
    private final PositionedItemStack[] layout;
    private final ResourceLocation recipeName;

    public ManualRecipeRef(ItemStack output) {
        this.output = Objects.requireNonNull(output);
        this.layout = null;
        this.recipeName = null;
    }

    public ManualRecipeRef(PositionedItemStack[] layout) {
        this.output = null;
        this.layout = Objects.requireNonNull(layout);
        this.recipeName = null;
    }

    public ManualRecipeRef(ResourceLocation recipeName) {
        this.output = null;
        this.layout = null;
        this.recipeName = Objects.requireNonNull(recipeName);
    }

    public boolean isLayout() {
        return this.layout != null;
    }

    public PositionedItemStack[] getLayout() {
        return Objects.requireNonNull(this.layout);
    }

    public boolean isResult() {
        return this.output != null;
    }

    public ItemStack getResult() {
        return Objects.requireNonNull(this.output);
    }

    public boolean isRecipeName() {
        return this.recipeName != null;
    }

    public ResourceLocation getRecipeName() {
        return Objects.requireNonNull(this.recipeName);
    }

    public <C extends Container, R extends Recipe<C>> void forEachMatchingRecipe(RecipeType<R> type, Consumer<R> out) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        this.forEachMatchingRecipe(type, PrivateAccess.getRecipes(recipeManager, type).values(), out);
    }

    public <C extends Container, R extends Recipe<C>> void forEachMatchingRecipe(RecipeType<R> type, Collection<R> allRecipes, Consumer<R> out) {
        if (this.isRecipeName()) {
            RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
            Recipe recipe = (Recipe)PrivateAccess.getRecipes(recipeManager, type).get(this.getRecipeName());
            if (recipe != null && this.matches(recipe)) {
                out.accept(recipe);
            }
        } else {
            for (Recipe recipe : allRecipes) {
                if (!this.matches(recipe)) continue;
                out.accept(recipe);
            }
        }
    }

    public boolean matches(Recipe<?> rec) {
        if (this.isResult() && ManualUtils.stackMatchesObject(rec.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), this.getResult())) {
            return true;
        }
        return this.isRecipeName() && this.getRecipeName().equals((Object)rec.m_6423_());
    }
}

